#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# clean extended attributes
# https://en.wikipedia.org/wiki/Extended_file_attributes
# http://www.freedesktop.org/wiki/CommonExtendedAttributes/
foreach my $name (@fileNames) {
   my @xattrCall = ("setfattr", '-x', 'user.xdg.comment', "$name", "2>&1>/dev/null");
   system @xattrCall;
}


__END__

=head1 SYNOPSIS

mattepaint-xattr - A Perl scrip to remove the user.xdg.comment.

mattepaint-xattr.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path


mattepaint-xattr.pl will remove user.xdg.comment from the file.

Note! 

This script is depending setfattr system command.

=cut 