#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use URI::Escape;
use Digest::MD5 qw(md5_hex);
use File::Copy;

# cache & config paths
# http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");
my $configPath = $ENV{XDG_CONFIG_HOME} || ("$ENV{HOME}/.config");

my $smplayerIni = "$configPath/smplayer/smplayer.ini";
my $smplayerConfig = $configPath . "/ffmpegthumbs-mattepaint/smplayer";
my $thumbfixerIni = $smplayerConfig . "/smplayer.ini";
my $imageTothumb = $configPath . "/ffmpegthumbs-mattepaint/ChosenOne";
my $seek = "screenshot_folder=";
my $replace = "screenshot_folder=$smplayerConfig/smplayer_screenshots \n";
my $smplayerShot = $smplayerConfig . "/smplayer_screenshots" . "/shot0001.png";

my $createMissingdir = $configPath . "/ffmpegthumbs-mattepaint";
mkdir $createMissingdir;
mkdir $createMissingdir . "/smplayer";
mkdir $createMissingdir . "/smplayer" ."/smplayer_screenshots";

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# override mp4 & matroska auto cover art
my @overrideCall = ( "mattepaint-override.pl", '1');
system (@overrideCall);

if ( !-e $thumbfixerIni ) {
   open(IN, "<$smplayerIni");
   open(OUT, ">$thumbfixerIni");

   while(my $row=<IN>) {
      if ($row =~/$seek/) {
         $row = $replace;
         print OUT $row;
      } else {
         print OUT $row;
     }
   }
}

# move snapshot to the ../ffmpegthumbs-mattepaint/chosenOne
foreach my $name (@fileNames) {
   my $fullName = "file://" . $name;
   my $escapedName = uri_escape("$fullName", "^A-Öa-ö0-9\-\.,_~/:()&!\@\\[\\]' ");
   $escapedName=~ s'\|'%7C'g;
   $escapedName=~ s'%24'$'g;
   $escapedName=~ s'\{'%7B'g;
   $escapedName=~ s'\}'%7D'g;
   my $thumbName = md5_hex("$escapedName") . ".png";
  
   my @smplayerCall = ("smplayer", '-config-path', "$smplayerConfig", "$name");
   system @smplayerCall;
  
   move ( $smplayerShot, $imageTothumb);

# remove old thumbnails
   unlink("$cachePath/thumbnails/large/$thumbName");
   unlink("$cachePath/thumbnails/normal/$thumbName");
   
#  refresh/reload the filemanager window
   my @konquerors = `"qdbus" "org.kde.konqueror*"`;
   chomp (@konquerors);
   foreach my $member (@konquerors) { system ("qdbus $member /konqueror/MainWindow_1 activateAction reload 2>/dev/null"); }

   my @dolphins = `"qdbus" "org.kde.dolphin*"`;
   chomp (@dolphins);
   foreach my $member (@dolphins) { system ("qdbus $member /dolphin/Dolphin_1 activateAction reload 2>/dev/null"); }

}

# disable override
sleep 1;
@overrideCall = ( "mattepaint-override.pl", '0');
system (@overrideCall);

__END__


=head1 SYNOPSIS

mattepaint-smplayer - A Perl helper scrip to use the SMPlayer screenshot as the KDE video thumbnail

mattepaint-smplayer.pl [options] [file(s)]

Options:

-help            this help message



mattepaint-smplayer.pl will write the SMPlayer screenshot to the ../ffmpegthumbs-mattepaint/ChosenOne 
and remove the existing thumbnails. Finally the script will reload the Dolphin/Konqueror windows.

Note !

This script is depending: SMPlayer

=cut 