#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use URI::Escape;
use Digest::MD5 qw(md5_hex);

# cache
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# thumbname
foreach my $name (@fileNames) {
   my $fullName = "file://" . $name;
   my $escapedName = uri_escape("$fullName", "^A-Öa-ö0-9\-\.,_~/:()&!\@\\[\\]' ");
   $escapedName=~ s'\|'%7C'g;
   $escapedName=~ s'%24'$'g;
   $escapedName=~ s'\{'%7B'g;
   $escapedName=~ s'\}'%7D'g;
   my $thumbName = md5_hex("$escapedName") . ".png";

# remove old thumbnails
   unlink("$cachePath/thumbnails/large/$thumbName");
   unlink("$cachePath/thumbnails/normal/$thumbName");
}

#  refresh/reload the filemanager window
my @konquerors = `"qdbus" "org.kde.konqueror*"`;
chomp (@konquerors);
foreach my $member (@konquerors) { system ("qdbus $member /konqueror/MainWindow_1 activateAction reload 2>/dev/null"); }

my @dolphins = `"qdbus" "org.kde.dolphin*"`;
chomp (@dolphins);
foreach my $member (@dolphins) { system ("qdbus $member /dolphin/Dolphin_1 activateAction reload 2>/dev/null"); }


__END__

=head1 SYNOPSIS

mattepaint-remover - A Perl scrip to remove the selected video thumbnails

mattepaint-remover.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path


mattepaint-remover.pl will read the given input video file names and remove
the thumbnail image files.

=cut 