#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# cache & config paths
# http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");
my $configPath = $ENV{XDG_CONFIG_HOME} || ("$ENV{HOME}/.config");

my $noAuto = $configPath . "/ffmpegthumbs-mattepaint/NoAuto";
my $createMissingdir = $configPath . "/ffmpegthumbs-mattepaint";
mkdir $createMissingdir;

my $onOff = $ARGV[0];

# user has added an empty /ffmpegthumbs-mattepaint/NoAuto
if ( -z "$noAuto" ) { exit; }

# remove or add a /ffmpegthumbs-mattepaint/NoAuto
if ( $onOff == 0 ) {
   unlink("$noAuto");
}else{
   open(my $override, '>', $noAuto) or die "Could not open file '$noAuto' $!";
   print $override "Temporary override\nRemove me !";
   close $override;
}

__END__

=head1 SYNOPSIS

mattepaint-override - A Perl helper scrip to override the mp4 and matroska automatic cover art.

mattepaint-override.pl

Options:

-help            this help message

mattepaint-override.pl will write/remove ../ffmpegthumbs-mattepaint/NoAuto to disable/enable the automatic cover art.
Command: 'mattepaint-override.pl 0' will remove the ../ffmpegthumbs-mattepaint/NoAuto.
Command: 'mattepaint-override.pl 1' add the ../ffmpegthumbs-mattepaint/NoAuto.

Note !

If there is an empty user made NoAuto file the script won't remove it.
Making an empty file to the ~/.config/ffmpegthumbs-mattepaint/NoAuto:
Command: 'touch ~/.config/ffmpegthumbs-mattepaint/NoAuto'.

=cut 