#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use URI::Escape;
use Digest::MD5 qw(md5_hex);
use File::Copy;
use Time::HiRes qw(usleep nanosleep);

my @pictureSuffix = ( '*.png','*.jpg');

# cache & config paths
# http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");
my $configPath = $ENV{XDG_CONFIG_HOME} || ("$ENV{HOME}/.config");

my $attachmentsToThumbnail = $configPath . "/ffmpegthumbs-mattepaint/CleanOne";
my $createMissingdir = $configPath . "/ffmpegthumbs-mattepaint";
my $parsleyDir = $createMissingdir . "/AtomicParsley/";

mkdir $createMissingdir;
mkdir $parsleyDir;

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# override mp4 & matroska auto cover art
my @overrideCall = ( "mattepaint-override.pl", '1');
system (@overrideCall);

# extract attached cover to the ../ffmpegthumbs-mattepaint/CleanOne
foreach my $name (@fileNames) {

   my $fullName = "file://" . $name;
   my $escapedName = uri_escape("$fullName", "^A-Öa-ö0-9\-\.,_~/:()&!\@\\[\\]' ");
   $escapedName=~ s'\|'%7C'g;
   $escapedName=~ s'%24'$'g;
   $escapedName=~ s'\{'%7B'g;
   $escapedName=~ s'\}'%7D'g;
   my $thumbName = md5_hex("$escapedName") . ".png";
  
   my @extractCall = ( "AtomicParsley", "$name", "-e", "$parsleyDir");
   system (@extractCall) == 0 or die "Can't execute the AtomicParsley";
   
   chdir $parsleyDir;
   my @globFiles = glob ("@pictureSuffix");
   if (scalar @globFiles == 0) { next; }
   if (scalar @globFiles > 1 ){
      my $pickThumbnail = `"kdialog" "--getopenfilename" "$parsleyDir"`;
      chomp ($pickThumbnail);
      copy ("$pickThumbnail", "$attachmentsToThumbnail") or die "Can't copy";
   } else {
      copy ("$globFiles[0]", "$attachmentsToThumbnail") or die "Can't copy";
   }   
   unlink @globFiles;

# remove old thumbnails
   unlink("$cachePath/thumbnails/large/$thumbName");
   unlink("$cachePath/thumbnails/normal/$thumbName");

#  refresh/reload the filemanager window
   my @konquerors = `"qdbus" "org.kde.konqueror*"`;
   chomp (@konquerors);
   foreach my $member (@konquerors) { system ("qdbus $member /konqueror/MainWindow_1 activateAction reload 2>/dev/null"); }

   my @dolphins = `"qdbus" "org.kde.dolphin*"`;
   chomp (@dolphins);
   foreach my $member (@dolphins) { system ("qdbus $member /dolphin/Dolphin_1 activateAction reload 2>/dev/null"); }

#  wait new thumbnail
   open( DUMP , ">/dev/null" );
   until ( -e "$cachePath/thumbnails/large/$thumbName" || -e  "$cachePath/thumbnails/normal/$thumbName" ) { 
      print DUMP "waiting thumbnail \n"; 
   }
   close (DUMP);
   usleep(5000);
}

# disable override
sleep 1;
@overrideCall = ( "mattepaint-override.pl", '0');
system (@overrideCall);

__END__

=head1 SYNOPSIS

mattepaint-mp42 - A Perl helper scrip to pick the attached mp4 file pictures as the KDE video thumbnail

mattepaint-mp42.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path

mattepaint-mp42.pl will write the picked picture to the ../ffmpegthumbs-mattepaint/CleanOne and remove the existing thumbnail. Finally the script will reload the Dolphin window.

Note! 

This script is depending: AtomicParsley and KDialog.

=cut
