#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use URI::Escape;
use Digest::MD5 qw(md5_hex);
use File::Copy;

my $file;

my $seek1 = "Attachment ID";
my $seek2 = "image";

# cache & config paths
# http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");
my $configPath = $ENV{XDG_CONFIG_HOME} || ("$ENV{HOME}/.config");

my $attachmentsToThumbnail = $configPath . "/ffmpegthumbs-mattepaint/CleanOne";
my $createMissingdir = $configPath . "/ffmpegthumbs-mattepaint";
my $matroskaDir = $createMissingdir . "/matroska";

mkdir $createMissingdir;
mkdir $matroskaDir;

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# override mp4 & matroska auto cover art
my @overrideCall = ( "mattepaint-override.pl", '1');
system (@overrideCall);

# extract attached poster to the ../ffmpegthumbs-mattepaint/CleanOne
foreach my $name (@fileNames) {
   my $i = 0;
   my $fileCount = 0;

   my $fullName = "file://" . $name;
   my $escapedName = uri_escape("$fullName", "^A-Öa-ö0-9\-\.,_~/:()&!\@\\[\\]' ");
   $escapedName=~ s'\|'%7C'g;
   $escapedName=~ s'%24'$'g;
   $escapedName=~ s'\{'%7B'g;
   $escapedName=~ s'\}'%7D'g;
   my $thumbName = md5_hex("$escapedName") . ".png";
  
   my @attachmentList = `"mkvmerge" '--ui-language' 'en_US' '-i' "$name"` or die "Can't execute the mkvmerge";

   foreach my $line (@attachmentList) {
      if ( $line =~/$seek1/ ) {
         $i++;
         if ( $line =~/$seek2/ ) {
               chdir "$matroskaDir" ;
               my @extractCall = ( "mkvextract", '--ui-language', 'en_US','attachments', "$name", "$i");
               system (@extractCall) == 0 or die "Can't execute the mkvextract";
         }
      }
   }

   ++$fileCount while glob "$matroskaDir/*";
   
   if ( $fileCount == 0 ){ next; }
   
   if ( $fileCount > 1 ){
      my $pickThumbnail = `"kdialog" "--getopenfilename" "$matroskaDir"`;
      chomp ($pickThumbnail);
      copy ($pickThumbnail, $attachmentsToThumbnail);
   } else {
      opendir(DIR, $matroskaDir);
      while ( defined($file = readdir(DIR)) ) {
         next if $file =~ /^\.\.?$/;
         copy ("$file", $attachmentsToThumbnail);
      }
      closedir(DIR);
   }
   
   opendir(DIR, "$matroskaDir");
   my @files= readdir(DIR);
   foreach my $file (@files) {
      unlink $file;
   }

# remove old thumbnails
   unlink("$cachePath/thumbnails/large/$thumbName");
   unlink("$cachePath/thumbnails/normal/$thumbName");

#  refresh/reload the filemanager window
   my @konquerors = `"qdbus" "org.kde.konqueror*"`;
   chomp (@konquerors);
   foreach my $member (@konquerors) { system ("qdbus $member /konqueror/MainWindow_1 activateAction reload 2>/dev/null"); }

   my @dolphins = `"qdbus" "org.kde.dolphin*"`;
   chomp (@dolphins);
   foreach my $member (@dolphins) { system ("qdbus $member /dolphin/Dolphin_1 activateAction reload 2>/dev/null"); }

#  wait new thumbnail
   open( DUMP , ">/dev/null" );
   until ( -e "$cachePath/thumbnails/large/$thumbName" || -e  "$cachePath/thumbnails/normal/$thumbName" ) { 
      print DUMP "waiting thumbnail \n"; 
   }
   close (DUMP);
}

# disable override
sleep 1;
@overrideCall = ( "mattepaint-override.pl", '0');
system (@overrideCall);

__END__

=head1 SYNOPSIS

mattepaint-matroska2 - A Perl helper scrip to pick the attached mkv file pictures as the KDE video thumbnail

mattepaint-matroska2.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path

mattepaint-matroska2.pl will write the picked picture to the ../ffmpegthumbs-mattepaint/thumbnails/cleanOne 
and remove the existing thumbnail. Finally the script will reload the Dolphin/Konqueror windows.

Note! 

This script is depending: mkvtoolnix-cli

=cut 