#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use File::Basename;

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

foreach my $fullName (@fileNames) {
    my $searchTerm = fileparse($fullName, qr/\.[^.]*/);
    $searchTerm =~ s' '+'g;
    system ("xdg-open 'https://www.google.com/search?&site=imghp&tbm=isch&q=$searchTerm'");
}

__END__

=head1 SYNOPSIS

mattepaint-google - A Perl scrip to open Google image search.

mattepaint-google.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path


mattepaint-google.pl will open Google image search to the browser.

Note!

This script is depending: xdg-open

=cut 