#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use URI::Escape;
use Digest::MD5 qw(md5_hex);
use Image::ObjectDetect;

# cache & config paths
# http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");
my $configPath = $ENV{XDG_CONFIG_HOME} || ("$ENV{HOME}/.config");

# using libkface - check your installation paths !!!
my $cascade  = '/usr/share/apps/libkface/haarcascades/haarcascade_frontalface_alt.xml';
my $detector = Image::ObjectDetect->new($cascade);

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# override mp4 & matroska auto cover art
my @overrideCall = ( "mattepaint-override.pl", '1');
system (@overrideCall);

foreach my $name (@fileNames) {
   my $fullName = "file://" . $name;
   my $escapedName = uri_escape("$fullName", "^A-Öa-ö0-9\-\.,_~/:()&!\@\\[\\]' ");
   $escapedName=~ s'\|'%7C'g;
   $escapedName=~ s'%24'$'g;
   $escapedName=~ s'\{'%7B'g;
   $escapedName=~ s'\}'%7D'g;
   my $thumbName = md5_hex("$escapedName") . ".png";

#  only working with the 'large' thumbnails
   my $picFile  = ("$cachePath/thumbnails/large/$thumbName");

#  search faces - try max 10 times
   for ( my $i = 1; $i <= 10; $i++ ) {

      my @faces = $detector->detect($picFile);
      last if ( scalar @faces > 0 );

# remove old thumbnails
      unlink("$cachePath/thumbnails/large/$thumbName");
      unlink("$cachePath/thumbnails/normal/$thumbName");

#  refresh/reload the filemanager window
      my @konquerors = `"qdbus" "org.kde.konqueror*"`;
      chomp (@konquerors);
      foreach my $member (@konquerors) { system ("qdbus $member /konqueror/MainWindow_1 activateAction reload 2>/dev/null"); }

      my @dolphins = `"qdbus" "org.kde.dolphin*"`;
      chomp (@dolphins);
      foreach my $member (@dolphins) { system ("qdbus $member /dolphin/Dolphin_1 activateAction reload 2>/dev/null"); }

#  wait new thumbnail
      open( DUMP , ">/dev/null" );
      until ( -e "$cachePath/thumbnails/large/$thumbName" || -e  "$cachePath/thumbnails/normal/$thumbName" ) { 
         print DUMP "waiting thumbnail \n"; 
      }
      close (DUMP);
   }
}

# disable override
sleep 1;
@overrideCall = ( "mattepaint-override.pl", '0');
system (@overrideCall);

__END__

=head1 SYNOPSIS

mattepaint-face - A Perl scrip to seek a thumbnail with faces

mattepaint-face.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path


mattepaintface.pl will read the given input video file names and seek
a new thumbnail with faces. 

Note! 

This script is only working with the 'large' thumbnails.

This script is depending: 

KDE libkface - haarcascade_frontalface_alt.xml
Perl module - Image::ObjectDetect

=cut 