#!/usr/bin/perl

use strict;
use warnings;

# start of help&doc 
use Getopt::Long;
use Pod::Usage;

GetOptions('help|?' => \my $help);
pod2usage("$0: No files given")  if ((@ARGV == 0) && (-t STDIN));
# end of help&doc

# perl modules
use Image::Magick;
use URI::Escape;
use Digest::MD5 qw(md5_hex);
use File::Copy;

# cache & config paths
# http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html
my $cachePath = $ENV{XDG_CACHE_HOME} || ("$ENV{HOME}/.cache");
my $configPath = $ENV{XDG_CONFIG_HOME} || ("$ENV{HOME}/.config");

my $imageTothumb = $configPath . "/ffmpegthumbs-mattepaint/CleanOne";
my $createMissingdir = $configPath . "/ffmpegthumbs-mattepaint";
mkdir $createMissingdir;

# work directory & qss
my $workDir = "$cachePath/dragNdrop";
mkdir $workDir;
my $styleSheet = "$workDir/.backStyle.qss";
chdir $workDir;

# Dolphin main widget size
my @dolphins = `"qdbus" "org.kde.dolphin*"`;
chomp (@dolphins);
my $lastDolphin = $dolphins[-1];
my $picWidth = `qdbus $lastDolphin /dolphin/Dolphin_1 org.qtproject.Qt.QWidget.width`;
chomp ($picWidth);
my $picHeight = `qdbus $lastDolphin /dolphin/Dolphin_1 org.qtproject.Qt.QWidget.height`-150;
chomp ($picHeight);
my $picSize = "$picWidth".'x'."$picHeight";

$ARGV[0] =~ s' /' //'g;
my @fileNames = split(' /', $ARGV[0]);

# override mp4 & matroska auto cover art
my @overrideCall = ( "mattepaint-override.pl", '1');
system (@overrideCall);

foreach my $name (@fileNames) {
   my $fullName = "file://" . $name;
   my $escapedName = uri_escape("$fullName", "^A-Öa-ö0-9\-\.,_~/:()&!\@\\[\\]' ");
   $escapedName=~ s'\|'%7C'g;
   $escapedName=~ s'%24'$'g;
   $escapedName=~ s'\{'%7B'g;
   $escapedName=~ s'\}'%7D'g;
   my $thumbName = md5_hex("$escapedName") . ".png";
   my $thumbnail = ("$cachePath/thumbnails/large/$thumbName");

#  qss background/drop target pic
#  http://www.imagemagick.org/script/perl-magick.php
   my $background = Image::Magick->new;
   $background->Set(size=> $picSize);
   $background->ReadImage('canvas:transparent');
   my $pic = Image::Magick->new;
   $pic->Read($thumbnail);
   $pic->Resize(geometry=> $picSize);
   $background->Composite(image=>$pic,compose=>'over', gravity=>'center');
   my $pictureOut = "$workDir/.target.png";
   $background->Write("$pictureOut");

   open(my $qss, '>', $styleSheet) or die "Could not open file '$styleSheet' $!";
   print $qss "DolphinViewContainer > DolphinView > QAbstractScrollArea {\n";
   print $qss "      border: none;\n";
   print $qss "      background-color: transparent;\n";
   print $qss "      border-image: url('.target.png') 0 0 0 0 stretch stretch;\n";
   print $qss "}\n";
   close $qss;

   my @globFiles1 = glob("$workDir/*");

   system ("dolphin -stylesheet $styleSheet $workDir &");

#  read file
   my $drop = 0;
   while ($drop eq 0) {
      sleep (1);
      my @globFiles2 = glob ("$workDir/*");
# if exit
      if ( -e "$workDir/e" ) {
         unlink("@globFiles2");
         system ("pkill -f $workDir");
         # disable override
         @overrideCall = ( "mattepaint-override.pl", '0');
         system (@overrideCall);
         exit;
      }
# if next
      if ( -e "$workDir/n" ) {
         unlink("@globFiles2");
         system ("pkill -f $workDir");
         last;
      }
      if (@globFiles1 ne @globFiles2) {
      my $fileType = `file '$globFiles2[0]'`;
# if image
          if ($fileType =~ /image/) {
             $drop = 1;
             copy ($globFiles2[0], $imageTothumb);
             unlink("@globFiles2");
             system ("pkill -f $workDir");
          }
# if google imgres
          if ($globFiles2[0] =~ /imgres/) {
              $drop = 1;
              my $before = '<title>';
              my $ending = '</title>';
              open(my $fh, '<', $globFiles2[0]);
              while (my $row = <$fh>) {
                  chomp $row;
                  if ($row =~ /$before/) {
                      $row =~ /$before(.*)$ending/;
                      my $url = $1;
                      $url =~ s/.*http/http/;
                      my $file = "$imageTothumb";
                      system ("wget -O $file $url");
#                     is image
                      my $checkType = `file "$file"`;
                      if ($checkType =~ /image/) {
                         unlink("@globFiles2");
                         system ("pkill -f $workDir");
#                     not image
                      } else {
                         my $note = Image::Magick->new;
                         $note->Set(size=> '256x256');
                         $note->ReadImage('canvas:white');
                         $note->Annotate( text=>'Not Image', gravity=>'Center', pointsize=>'52');
                         $note->Write("$file.png");
                         rename ("$file.png","$file");
                         unlink("@globFiles2");
                         system ("pkill -f $workDir");
                      }
                  }
              }
          }
       }
   }

   if ($drop eq 1) {
# remove old thumbnails
      unlink("$cachePath/thumbnails/large/$thumbName");
      unlink("$cachePath/thumbnails/normal/$thumbName");

#  refresh/reload the filemanager window
      my @konquerors = `"qdbus" "org.kde.konqueror*"`;
      chomp (@konquerors);
      foreach my $member (@konquerors) { system ("qdbus $member /konqueror/MainWindow_1 activateAction reload 2>/dev/null"); }

      @dolphins = `"qdbus" "org.kde.dolphin*"`;
      chomp (@dolphins);
      foreach my $member (@dolphins) { system ("qdbus $member /dolphin/Dolphin_1 activateAction reload 2>/dev/null"); }
   }
}

# disable override
sleep 1;
@overrideCall = ( "mattepaint-override.pl", '0');
system (@overrideCall);

__END__

=head1 SYNOPSIS

mattepaint-dragndrop - A Perl scrip to pick the selected video thumbnails

mattepaint-dragndrop.pl [options] [file(s)]

Options:

-help            this help message

Files:

List of files with full path


mattepaint-dragndrop.pl will replace the selected thumbnails with image files.

Note !

This script is depending: 

Perl module Image::Magick
Dolphin
pkill
wget


=cut 