%----Begin of octave script, don't edit:--
clear;
cd ~/.gimp-octave
load matrix_in.txt;
[rows, cols, bpp] = size(matrix_in)
tmp = matrix_in;
%-----------------------------------------




%----Put your own stuff here:-------------
% http://www.csse.uwa.edu.au/~pk/Research/MatlabFns/index.html
%  1 = phasecong2
%  2 = spatialgabor
%  3 = phasesym
%  4 = gaborconvolve
%  5 = monofilt
%  6 = edge
%  7 = anisodiff
%  8 = adjcontrast
%  9 = homomorphic

method = 1;

switch (method)

case 1
    %tmp = phasecong2(tmp);
    tmp = fftshift(tmp);

case 2
    % [Eim, Oim, Aim] =  spatialgabor(im, wavelength, angle, kx, ky, showfilter)
    [a tmp b] = spatialgabor(tmp, 1, 0, 0.5, 0.5, 0);

case 3
    [tmp a b] = phasesym(tmp);

case 4
    % gaborconvolve(im2, nscale, norient, minWaveLength, mult, sigmaOnf, dThetaOnSigma, feedback, scale, orientation)
    tmp = angle(gaborconvolve(tmp, 4, 6, 3, 2, 0.65, 1.5, 0, 4, 6));

case 5
    % function [f, h1f, h2f, A, theta, psi] = monofilt(im2, nscale, minWaveLength, mult, sigmaOnf, orientWrap)
    [f, h1f, h2f, A, theta, psi] = monofilt(tmp, 3, 4, 2, 0.65, 0);
    for t = 1:bpp
        tmp(:,:,t) = f{1,1}; %first cell
    end

case 6
    tmp6=zeros(rows,cols);
    if(bpp>1)
	for t=1:bpp,
	    tmp6 += tmp(:,:,t);
	end
	tmp6 = abs(floor(tmp6./bpp)) + 1;
    else
	tmp6=tmp;
    end
    
    tmp6 = edge(ind2gray(tmp6, gray (max(tmp6(:)))),'canny', [0.1 0.2], 1);
    
    if(bpp>1)
	tmp=zeros(rows,cols,bpp);
	for t=1:bpp,
	    tmp(:,:,t)=tmp6;
	end
    else
	tmp=tmp6;
    end

case 7
    % diff = anisodiff(im, niter, kappa, lambda, option)
    tmp = anisodiff(tmp, 100, 30, 0.1, 1);
    
case 8
    % g = adjcontrast(im, gain, cutoff)
    tmp = adjcontrast(tmp, 10, 0.5);

case 9
    % him = homomorphic(im, boost, CutOff, order, varargin)
    tmp9=zeros(rows,cols);
    if(bpp>1)
	for t=1:bpp,
	    tmp(:,:,t) = homomorphic(tmp(:,:,t), 2, .25, 2, 0, 5);
	end
    else
	tmp = homomorphic(tmp, 2, .25, 2, 0, 5);
    end
    
otherwise
    printf("Wrong method!\n");
endswitch

%stretch from 0 to 255
tmp = tmp .- min(tmp(:));
tmp = 255*tmp/(max(tmp(:)));
%-----------------------------------------




%----End of octave script, don't edit:----
matrix_out = round(tmp);
matrix_out(matrix_out(:)<0)=0;
matrix_out(matrix_out(:)>255)=255;
dims = ndims (matrix_out)
if (dims == 2)
    matrix_out = resize (matrix_out, [size(matrix_out, 1), size(matrix_out, 2), 1]);
end

size(matrix_out)
save matrix_out.txt matrix_out;
%-----------------------------------------


