#include "LtrdConnectionSettings.h"
#include "ui_LtrdConnectionSettings.h"
#include "LtrdConnection.h"
#include <QMessageBox>

LtrdConnectionSettings::LtrdConnectionSettings(LtrdConnection *con, QStringList logLvlNames, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LtrdConnectionSettings),
    m_con(con) {

    ui->setupUi(this);
    setWindowTitle(tr("%1 settings").arg(LTR_SERVICE_NAME));

    int err = 0;
    unsigned val = 0;


    ui->logLvlBox->addItems(logLvlNames);

    err = con->getLogLevel(&val);
    if (!err)
        ui->logLvlBox->setCurrentIndex(val);
    if (!err)
        err = con->getUintParam(LTRD_PARAM_ETH_CRATE_POLL_TIME, &val);
    if (!err)
        ui->ethCratePollTime->setValue(val);
    if (!err)
        err = con->getUintParam(LTRD_PARAM_ETH_CRATE_CTLCMD_TOUT, &val);
    if (!err)
        ui->ethCrateCtlTout->setValue(val);
    if (!err)
        err = con->getUintParam(LTRD_PARAM_ETH_CRATE_CON_TOUT, &val);
    if (!err)
        ui->ethCrateConTout->setValue(val);

    if (!err && con->supportReconnection()) {
        err = con->getUintParam(LTRD_PARAM_ETH_CRATE_RECONNECT_TIME, &val);
        if (!err)
            ui->ethCrateReconTime->setValue(val);
    } else {
        ui->ethCrateReconTime->setEnabled(false);
    }

    if (err) {
        QMessageBox::critical(this, tr("Get settings error!"),
                              tr("Cannot get ltrd settings. Error %1").arg(err),
                              QMessageBox::Ok, QMessageBox::Ok);
    }
}

LtrdConnectionSettings::~LtrdConnectionSettings() {
    delete ui;
}

void LtrdConnectionSettings::accept() {
    int err = 0;
    err = m_con->setLogLevel(ui->logLvlBox->currentIndex());
    if (!err)
        err = m_con->setUintParam(LTRD_PARAM_ETH_CRATE_POLL_TIME, ui->ethCratePollTime->value());
    if (!err)
        err = m_con->setUintParam(LTRD_PARAM_ETH_CRATE_CTLCMD_TOUT, ui->ethCrateCtlTout->value());
    if (!err)
        err = m_con->setUintParam(LTRD_PARAM_ETH_CRATE_CON_TOUT, ui->ethCrateConTout->value());
    if (!err && m_con->supportReconnection())
        err = m_con->setUintParam(LTRD_PARAM_ETH_CRATE_RECONNECT_TIME, ui->ethCrateReconTime->value());

    if (!err) {
        QDialog::accept();
    } else {
        QMessageBox::critical(this, tr("Set settings error!"),
                              tr("Cannot set ltrd settings. Error %1").arg(err),
                              QMessageBox::Ok, QMessageBox::Ok);
    }
}
