#ifndef LTRSRV_ETH_H
#define LTRSRV_ETH_H

#include <stdint.h>
#include "ltrsrv_crates.h"


typedef enum {
    LTR_CRATE_IP_FLAG_AUTOCONNECT = 0x00000001, /** признак, что нужно пробовать
                                                   соединится по этой записи при
                                                   старте и при ltrsrv_eth_start_autocon() */
    LTR_CRATE_IP_FLAG_RECONNECT   = 0x00000002, /** Признак, что нужно выполнять повторное
                                                    подключение в случае ошибки */
} t_ltr_crate_ip_flags;


typedef enum {
    /** Интервал опроса крейта, для проверки, рабочее ли подключение (в мс) */
    LTR_SERVER_PARAM_ETH_CRATE_POLL_TIME   = 0x100,
    /** Таймаут на установление соединения с крейтом (в мс) */
    LTR_SERVER_PARAM_ETH_CRATE_CON_TOUT    = 0x101,
    /** Таймаут на ответ на управляющую команду от крейта (в мс) */
    LTR_SERVER_PARAM_ETH_CRATE_CTLCMD_TOUT = 0x102,
    /** Интервал проверки адресов хоста для запуска автоподключения (в мс) */
    LTR_SERVER_PARAM_ETH_INTF_CHECK_TIME   = 0x103,
    /** Время на повторное подключения крейта по Ethernet после ошибки (в мс) */
    LTR_SERVER_PARAM_ETH_RECONNECTION_TIME = 0x104
} t_ltr_server_params;

typedef enum {
    LTR_CRATE_IP_STATUS_OFFLINE     = 0,
    LTR_CRATE_IP_STATUS_CONNECTING  = 1,
    LTR_CRATE_IP_STATUS_ONLINE      = 2,
    LTR_CRATE_IP_STATUS_ERROR       = 3
} t_ltr_crate_ip_status;

typedef struct {
    uint32_t ip_addr;
    uint32_t flags;
    char serial_number[16];
    uint8_t is_dynamic;
    uint8_t status;
} t_ltr_crate_client_ip_entry;


int ltrsrv_eth_init(void);
int ltrsrv_eth_close(void);

int ltrsrv_eth_start_autocon(void);

int ltrsrv_eth_get_ip_entry_list(t_ltr_crate_client_ip_entry* lst, int max_cnt, uint32_t msk, uint32_t addr, uint32_t *fnd_cnt);
int ltrsrv_eth_add_ip_entry(uint32_t addr, uint32_t flags, int permanent, int modify);
int ltrsrv_eth_rem_ip_entry(uint32_t addr, int permanent, int modify);
int ltrsrv_eth_ip_conn(uint32_t addr);
int ltrsrv_eth_ip_disc(uint32_t addr);
int ltrsrv_eth_ip_disc_all(void);
int ltrsrv_eth_ip_set_flags(uint32_t addr, uint32_t flags, int permanent, int modify);

int ltrsrv_get_next_saved_ip_entry(int start_ind, t_ltr_crate_client_ip_entry* entry);

int ltrsrv_eth_set_param(t_ltr_server_params param, const void *val, uint32_t snd_size);
int ltrsrv_eth_get_param(t_ltr_server_params param, void *val, uint32_t* snd_size);

#endif
