/***************************************************************************//**
  @ingroup ltimer
  @defgroup ltimer_linux Порт таймера для Linux
  Порт для работы с таймером в ОС Linux. Для получения системного счетчика
  использует функцию clock_gettime() из librt для получения CLOCK_MONOTONIC,
  который нельзя устанавливать и дает приемлемую точность (если нет в ОС, то 
  используется TIMEOFDAY).
  *****************************************************************************/
/***************************************************************************//**
  @ingroup ltimer_linux
  @file ports/linux/lclock_arch.h
  Файл содержит определение типов и констант для работы с системным счетчиком
  в OC Linux через функцию clock_gettime().
  @author Borisov Alexey <borisov@lcard.ru>
 ******************************************************************************/

#ifndef LCLOCK_ARCH_H_
#define LCLOCK_ARCH_H_

#include <stdint.h>

/* Возвращаем счетчик в миллисекундах, хотя clock_gettime() может дать нс,
   но реально они не изменяются + с мс сохраняется достаточное время 
   переполнения для 32-битного счетчика */
#define LCLOCK_TICKS_PER_SECOND 1000

/* для простоты и скорости операций используем 32-битное слово */
typedef uint32_t t_lclock_ticks;

#endif /* LCLOCK_ARCH_H_ */
