#include "ltr01api.h"
#include "ltrmodule.h"

#define CMD_ID_REQUEST          (LTR010CMD_INSTR | 0x00)
#define RESP_ID_REQUEST         (LTR010CMD_INSTR | 0x00)

static struct
{
    WORD id;
    const char* name;
} f_modules_names[] =
{
    {LTR01_SUBID_LTRS511, "LTRS-511"},
    {LTR01_SUBID_LTRS411, "LTRS-411"},
    {LTR01_SUBID_LTRS412, "LTRS-412"},
    {LTR01_SUBID_LTRT10,  "LTRT-10"}
};



LTR01API_DllExport(INT) LTR01_Open(TLTR *hnd, DWORD net_addr, WORD net_port,
                                   const CHAR *crate_sn, INT slot_num, WORD subid, BYTE *cpld_ver)
{
    DWORD open_flags = 0;
    INT warning, err = hnd==NULL ? LTR_ERROR_INVALID_MODULE_DESCR : LTR_OK;
    if (err==LTR_OK)
    {
        DWORD ack;
        err = ltr_module_open(hnd, net_addr, net_port, crate_sn, slot_num,
                              LTR_MID_LTR01, &open_flags, &ack, &warning);

        /* проверяем совпадение дополнительного идентификатора, если нужно */
        if ((err==LTR_OK) && (subid != LTR01_SUBID_INVALID))
        {
            WORD recv_subid;
            err = LTR01_GetModuleSubID(hnd, &recv_subid);
            if ((err==LTR_OK) && (recv_subid!=subid))
                err = LTR_ERROR_INVALID_MODULE_ID;
        }

        /* возвращаем версию CPLD, если нужно */
        if ((err==LTR_OK) && (cpld_ver!=NULL))
        {
            *cpld_ver = ack & 0x3F;
        }
    }
    return err==LTR_OK ? warning : err;
}


LTR01API_DllExport(INT) LTR01_Close(TLTR *hnd)
{
    return LTR_Close(hnd);
}

LTR01API_DllExport(INT) LTR01_GetModuleSubID(TLTR *hnd, WORD* subid)
{
    INT err = subid==NULL ? LTR_ERROR_PARAMETERS : LTR_IsOpened(hnd);
    if (err==LTR_OK)
    {
        DWORD cmd = LTR_MODULE_MAKE_CMD(CMD_ID_REQUEST, 0);
        DWORD resp = LTR_MODULE_MAKE_CMD(RESP_ID_REQUEST, 0);
        err = ltr_module_send_with_single_resp(hnd, &cmd, 1, &resp);
        if (err==LTR_OK)
        {
            *subid = LTR_MODULE_CMD_DATA(resp);
        }
    }
    return err;
}

LTR01API_DllExport(INT) LTR01_GetSubID(DWORD net_addr, WORD net_port, const CHAR *csn, INT slot, WORD *subid)
{
    TLTR hnd;
    INT err;
    LTR_Init(&hnd);
    err = LTR01_Open(&hnd, net_addr, net_port, csn, slot, LTR01_SUBID_INVALID, NULL);
    if (err==LTR_OK)
    {
        err = LTR01_GetModuleSubID(&hnd, subid);
    }

    if (LTR_IsOpened(&hnd)==LTR_OK)
    {
        INT close_err = LTR01_Close(&hnd);
        if (err==LTR_OK)
            err = close_err;
    }
    return err;
}

LTR01API_DllExport(LPCSTR) LTR01_GetModuleName(WORD subid)
{
    const char* res = "LTR01 (Unknown)";
    unsigned i, fnd;
    for (i=0, fnd=0; !fnd && (i<sizeof(f_modules_names)/sizeof(f_modules_names[0])); i++)
    {
        if (f_modules_names[i].id == subid)
        {
            fnd = 1;
            res = f_modules_names[i].name;
        }
    }
    return res;
}

