Общий подход к использованию интерфейсных функций{#sect_gen_descr}
==============================================================

  Общий алгоритм работы с модулем{#sect_gen_alg}
  ==============================================================

Данный раздел описывает типичную последовательность действий при работе с модулем LTR35. Более подробно каждый шаг будет описан в последующих разделах.

Типичная последовательность действий имеет следующий вид:
1. Создать экземпляр структуры TLTR35, представляющей собой описатель модуля. Описатель модуля содержит всю информацию о модуле и используется при вызове всех остальных функций.
2. Проинициализировать поля описателя с помощью LTR35_Init()
3. Установить соединение с интересующим модулем с помощью функции LTR35_Open().
4. Заполнить необходимые поля с настройками модуля подструктуры [Cfg](@ref TLTR35::Cfg) [описателя модуля](@ref TLTR35) и вызвать LTR35_Configure() для записи настроек в модуль.
5. Шаги для подготовки и выдачи данных зависят от используемого [режима модуля](@ref sect_gen_modes) и описаны ниже
8. По завершению работы выполнить останов выдачи данных с помощью LTR35_Stop() или LTR35_StopWithTout().
9. Закрыть соединение с модулем, вызвав функцию LTR35_Close().
 
Вывод сигнала при режиме циклического автогенератора{#sect_gen_alg_cycle}
-------------------------------------------------------------------
Для записи и выдачи периодических сигналов в режиме [циклического автогенератора](@ref sect_gen_mode_cycle) нужно выполнить следующие шаги:
1. Подготовить данные для выдачи в нужном формате с помощью LTR35_PrepareData() или LTR35_PrepareDacData().
2. Передать подготовленные данные в модуль с помощью LTR35_Send() .
3. При необходимости повторить пункты 1 и 2 нужное количество раз, чтобы передать в модуль все отсчеты воспроизводимых сигналов.
4. Вызвать функцию LTR35_SwitchCyclePage() по которой загруженные данные начинают выдаваться на ЦАП/цифровые линии.
5. При необходимости выставить новый сигнал повторить пункты 1-4 для выдачи следующего набора сигналов.

Вывод сигнала при потоковом режиме{#sect_gen_alg_stream}
-------------------------------------------------------------
Для записи и выдачи сигналов в [потоковом режиме](@ref sect_gen_mode_stream) нужно выполнить следующие шаги
1. Подготовить блок данных для выдачи в нужном формате с помощью LTR35_PrepareData() или LTR35_PrepareDacData() и передать в модуль с помощью LTR35_Send().
2. Запустить выдачу данных в потоковом режиме с помощью LTR35_StreamStart().
3. По мере необходимости подготавливать и подгружать в буфер LTR35 новые данные по аналогии с пунктом 1.


Настройка модуля{#sect_gen_cfg}
=============================================================
Настройка модуля должна выполняться хотя бы один раз после установления связи с модулем до загрузки данных на выдачу.

Настройка модуля выполняется аналогично большинству других модулей LTR: вначале значения всех параметров модуля записываются в соответствующие поля [структуры описателя модуля](@ref TLTR35), затем вызывается функция LTR35_Configure(), которая значения этих полей передает модулю.

Следует отметить, что все поля, относящиеся к настройке модуля, объединены в структуру типа #TLTR35_CONFIG (поле  [Cfg](@ref TLTR35::Cfg) [описателя модуля](@ref TLTR35)). Только эти поля пользователь должен изменять вручную в [описателе модуля](@ref TLTR35) при штатной работе и только эти поля влияют на параметры, записываемые LTR35_Configure().

При настройке модуля задаются следующие параметры:
- Частота преобразования ЦАП (раздел @ref sect_gen_cfg_dac_freq)
- Настройки каналов ЦАП (раздел @ref sect_gen_cfg_dac_ch) 
- Настройка режима работы. Задается полем [Mode](@ref TLTR35_CONFIG::Mode). Режимы более подробно описаны в разделе @ref sect_gen_modes.
- Настройка формата передаваемых данных (раздел @ref sect_gen_cfg_data_fmt) 
- Настройка арифметических генераторов (раздел @ref sect_gen_cfg_arith)
- Настройка выдачи эхо-данных (раздел @ref sect_gen_cfg_echo) 


После выполнения LTR35_Configure() рассчитываются некоторые параметры, которые являются производными от настроек из #TLTR35_CONFIG. Эти параметры записываются в соответствующие поля структуры состояния модуля типа #TLTR35_STATE (поле [ State](@ref TLTR35::State) [описателя модуля](@ref TLTR35)). 



Настройка частоты преобразования ЦАП и вывода на цифровые линии{#sect_gen_cfg_dac_freq}
---------------------------------------------------------------

Основной частотой преобразования ЦАП является частота 192 КГц (определена константой #LTR35_DAC_FREQ_DEFAULT). Но при необходимости пользователь может гибко настраивать частоту преобразования. Тем не менее следует учесть, что все метрологические характеристики модуля проверяются только для частоты 192 КГц.

Частота преобразования задается одна на все каналы ЦАП, а также с этой частотой производится вывод значений на цифровые линии, т.е. вывод на все разрешенные каналы ЦАП и цифровые лини происходит одновременно. При этом частота преобразования не зависит от количества разрешенных каналов. Однако в [потоковом режиме](@ref sect_gen_mode_stream) следует учитывать ограничения скорости интерфейса между модулем и крейтом.

Для того, чтобы иметь возможность гибко настраивать частоту преобразования в модуле LTR35 установлен синтезатор частоты. На вход синтезатора подается частота 30 МГц от единого опорного генератора крейта LTR (общая для всех модулей крейта). На выходе синтезатора получается частота, определяемая его настройками, которые задаются полем [Synt](@ref TLTR35_CONFIG::Synt) в [настройках модуля](@ref TLTR35::Cfg) и описываются структурой #TLTR35_SYNT_CONFIG. Формула рассчета полученной частоты приведена в описании структуры. Далее с синтезатора эта частота подается на ЦАП. При этом скольким периодам частоты синтезатора соответствует период выдачи одного отсчета ЦАП (или цифровых линий) определяется настройкой скорости выдачи, задаваемой полем [DacRate](@ref TLTR35_CONFIG::DacRate) структуры с конфигурацией модуля.

Следует отметить, что пользователю не обязательно заполнять эти настройки вручную. Для заполнения этих полей предназначена функция LTR35_FillFreq(), которая сама подбирает подходящие настройки так, чтобы результирующая частота преобразования ЦАП (и вывода на цифровые линии) была наиболее близка к заданной пользователем.




Настройки каналов ЦАП{#sect_gen_cfg_dac_ch}
-------------------------------------------------------------
В модуле LTR35 может быть 8, 4 или 0 каналов ЦАП в зависимости от модификации модуля. Количество каналов можно узнать по полю [DacChCnt](@ref TINFO_LTR35::DacChCnt) структуры с [информацией о модуле](@ref TLTR35::ModuleInfo) после установления связи с модулем. 

Настройки каждого канала объединены в структуре #TLTR35_CHANNEL_CONFIG. Массив структур, каждый элемент которого соответствует нужному каналу, является полем [Ch](@ref TLTR35_CONFIG::Ch) структуры с [настройками модуля](@ref TLTR35::Cfg). Для каждого канала может быть настроено:
 - Разрешена ли выдача данных по этому каналу. Задается полем [Enabled](@ref TLTR35_CHANNEL_CONFIG::Enabled).
 - Какой из двух выходов используется для данного канала. Задается полем [Output](@ref TLTR35_CHANNEL_CONFIG::Output). Для каждого канала есть два выхода с разным диапазоном амплитуд воспроизводимого сигнала. Диапазоны каждого выхода зависят от модификации модуля. При этом максимальное и минимальное значения для каждого выхода доступны в описании выходов (массив [DacOutDescr](@ref TINFO_LTR35::DacOutDescr) структуры с [информацией о модуле](@ref TLTR35::ModuleInfo)). В действительности сигнал воспроизводится всегда на обоих выходах канала, однако метрологические характеристики обеспечиваются только на заданном, так как применяются калибровочные коэффициенты именно для указанного выхода. 
 - Источник сигнала для данного канала ЦАП. Задается полем  [Source](@ref TLTR35_CHANNEL_CONFIG::Source). Источником могут быть как  отсчеты, загруженные в буфер модуля (#LTR35_CH_SRC_SDRAM), так и отсчеты, генерируемые внутри модуля арифметическими генераторами. О арифметических генераторах и полях для их настройки описано в разделе @ref sect_gen_cfg_arith.
 
 
Настройка арифметических генераторов{#sect_gen_cfg_arith}
----------------------------------------------------------------
В модуле LTR35 присутствует 4 (#LTR35_ARITH_SRC_CNT) синусоидальных арифметических генератора. У каждого генератора есть два выхода --- синус и косинус. Любой выход любого генератора можно подать на любой выход ЦАП, задав в настройках этого выхода ЦАП в поле [Source](@ref TLTR35_CHANNEL_CONFIG::Source) соответствующее значение (при этом один выход арифметического генератора может быть подан на несколько каналов ЦАП). 

В случае, если на один или несколько каналов ЦАП нужно вывести синусоидальный сигнал заданной частоты, фазы, амплитуды и смещения, то использование арифметических генераторов позволяет сделать это не формируя сигнал в памяти и не загружая его в буфер модуля. Это в частности позволяет:
- Уменьшить время загрузки сигнала. При этом смену частоты, амплитуды и смещения можно выполнять посылкой минимального количества команд (функции LTR35_SetArithSrcDelta() и LTR35_SetArithAmp()), не влияя на остальные каналы при запущенной выдаче.
- Уменьшить поток данных в модуль, что позволяет использовать больше каналов в [потоковом режиме](@ref sect_gen_mode_stream).
- Избежать занимаемого места в странице памяти в режиме [циклического автогенератора](@ref sect_gen_mode_cycle). При этом смена страниц не требует загрузки отсчетов для каналов в режиме арифметического генератора, а для смены частоты сигналов на этих каналах не требуется повторная загрузка страницы с отсчетами других каналов.

Структура #TLTR35_ARITH_SRC_CONFIG содержит настройки одного арифметического генератора. Массив структур, каждый элемент которого соответствует нужному арифметическому генератору, является полем [ArithSrc](@ref TLTR35_CONFIG::Ch) структуры с [настройками модуля](@ref TLTR35::Cfg). Для каждого арифметического генератора может быть настроена частота и начальная фаза (поле [Phase](@ref TLTR35_ARITH_SRC_CONFIG::Phase)) сигнала. Частота задается с помощью поля [Delta](@ref TLTR35_ARITH_SRC_CONFIG::Delta), которое задает значение приращения фазы для каждого последующего отсчета в радианах. При этом частота выходного сигнала будет равна:
\f[ f_{sig} = \frac{f_{dac}*Delta}{2*\pi} \f]

При этом амплитуда и смещение задаются в Вольтах непосредственно в настройках канала #TLTR35_CHANNEL_CONFIG полями [ArithAmp](@ref TLTR35_CHANNEL_CONFIG::ArithAmp) и [ArithOffs](@ref TLTR35_CHANNEL_CONFIG::ArithOffs) соответственно. Эти настройки являются свойством канала, а не настройками генератора, т.е. для вывода на разные каналы синусоидальных сигналов с одинаковой частотой и фазой, но разными амплитудами и/или смещением можно использовать один и тот же генератор.

Два выхода каждого генератора (синус и косинус) могут быть использованы для получения с помощью одного генератора одинаковых сигналов (возможно с разными амплитудами), сдвинутых по фазе на \f$ \pi/2 \f$.

Следует также отметить, что в [потоковом режиме](@ref sect_gen_mode_stream) генерация сигнала на каналах, выдающих сигнал с одного из арифметических генераторов, не зависит от состояния очереди потоковых данных, т.е. если происходит опустошение очереди, то генерация синусоидальных сигналов все равно выполняется непрерывно.


Настройка формата передаваемых данных{#sect_gen_cfg_data_fmt}
------------------------------------------------------------
Поле [DataFmt](@ref TLTR35_CONFIG::DataFmt) задает формат отсчетов при передаче от ПК в буфер модуля. Использование 20-битного формата (#LTR35_FORMAT_20) приводит к потере младших 4-х бит отсчетов ЦАП по сравнению c 24-х битным (#LTR35_FORMAT_24), но позволяет в 2 раза уменьшить объем данных, передаваемых в буфер модуля, так как в этом формате каждый отсчет занимает одно 32-битное слово LTR, а не два. Следует заметить, что формат влияет только на формат передаваемых слов, а не на формат отсчетов, хранящихся уже в самом буфере модуля --- в буфере модуля может хранится одинаковое количество отсчетов независимо от формата передаваемых данных.

Таким образом, использование 20-битного формата может быть полезно в первую очередь в [потоковом режиме](@ref sect_gen_mode_stream), что позволяет задействовать больше каналов на большей частоте. В потоковом режиме скорость передачи интерфейса ограничивается значением 500 КСлов/c, что ограничивает количество используемых каналов LTR35.


Настройка выдачи эхо-данных{#sect_gen_cfg_echo}
-----------------------------------------------------------
При желании можно настроить модуль LTR35 так, что он будет при каждом выводе отсчета одного канала ЦАП передавать слово непосредственно с тем кодом, который записывается в соответствующий канал ЦАП в этот момент. Это можно использовать для того, чтобы в ручную контролировать заполненность буфера в [потоковом режиме](@ref sect_gen_mode_stream), либо чтобы воссоздать картину выдаваемого сигнала, привязанную к сбору данных других модулей с помощью синхронметок крейтовой системы LTR. 

Возвращаемые коды --- это непосредственно коды, записываемые в ЦАП настроенного канала каждый период преобразования. В связи с этим, следует отметить следующие особенности возвращаемых эхо-данных:
 - Возвращаемые в эхо-данных коды ЦАП отличаются от посылаемых, так как возвращаются коды с уже примененными калибровочными коэффициентами внутри модуля.
 - В [потоковом режиме](@ref sect_gen_mode_stream), если происходит опустошение очереди и один и тот же отсчет выводится повторно несколько периодов преобразования, то ответ будет выслан на каждый период. Таким образом, при опустошении очереди количество высланных слов с эхо-данными может не совпадать с количеством посланных отсчетов по данному каналу.
 - На генерацию эхо-данных может быть настроен и канал, отсчеты которого не подгружаются в буфер модуля, а генерируются одним из [арифметических генераторов](@ref sect_gen_cfg_arith).
 - Количество переданных слов с эхо-данными и их формат не зависят от настроенного [формата посылаемых данных](@ref sect_gen_cfg_data_fmt). Модуль всегда высылает одно 32-битное слово LTR на один период преобразования ЦАП при разрешенной выдаче эхо-данных.
 
На выдачу эхо-данных может быть настроен только один канал. Изначально выдача эхо-данных запрещена. Для разрешение необходимо установить в единичное значение поле [EchoEnable](@ref TLTR35_CONFIG::EchoEnable) и установить номер канала для генерации эхо-данных в поле [EchoChannel](@ref TLTR35_CONFIG::EchoChannel) структуры с [настройками модуля](@ref TLTR35::Cfg).

Прием ответов от модуля осуществляется с помощью функции LTR35_RecvEchoResp().

Режимы работы модуля{#sect_gen_modes}
============================================

Режим работы модуля устанавливается с помощью поля [Mode](@ref TLTR35_CONFIG::Mode) структуры с [настройками модуля](@ref TLTR35::Cfg) и влияет на то, как используется внутренний буфер модуля. Т.е. режим влияет на каналы, данные для которых загружаются в буфер модуля --- то есть, каналы ЦАП с источником [Source](@ref TLTR35_CHANNEL_CONFIG::Source) = #LTR35_CH_SRC_SDRAM и вывод на цифровые линии. При этом в любом режиме часть каналов ЦАП может быть также настроена на работу от одного из [арифметических генераторов](@ref sect_gen_cfg_arith). Работа этих каналов не зависит от режима, так как они не требует загрузки данных в буфер.

Потоковый режим работы модуля{#sect_gen_mode_stream}
-------------------------------------------------
Потоковый режим требует поддержки анализа статусов очереди в программе ltrd (или LtrServer). Данная поддержка реализована в ltrd начиная с версии 2.1.3.0.

Следует иметь ввиду, что максимальная скорость потока вывода не должна превышать скорости интерфейса между крейтом и модулем равной 500 КСлов/с. Т.е. в случае необходимости обеспечения непрерывного вывода при частоте преобразования 192 КГц при 24-битном режиме может быть разрешен только один канал, настроенный на выдачу данных из буфера модуля, а при 20-битном --- только два. Для большего числа каналов в потоковом режиме при непрерывном выводе необходимо уменьшать частоту преобразования.

В потоковом режиме буфер модуля LTR35 представляет собой очередь на 8 миллионов отсчетов. Подгружаемые в модуль слова сохраняются в конец очереди. При попытке передать слово в модуль, очередь которого полностью заполнена, записываемое слово будет отброшено и будет установлен соответствующий флаг в следующем высланном периодическом статусе.

При вызове LTR35_StreamStart() разрешается выдача данных на ЦАП/цифровые линии в потоковом режиме. Раз в период преобразования ЦАП модуль пытается прочитать из начала очереди требуемое количество отсчетов (читается до 9 отсчетов в зависимости от разрешенных каналов --- чтение заканчивается на чтении отсчета, соответствующего последнему разрешенному каналу ЦАП). Если требуемых отсчетов не оказалось, то выводится повторно последнее выведенное слово. При этом в следующем периодическом статусе будет установлен признак, что было опустошение очереди.

При необходимости обеспечить непрерывный вывод, чтобы не было опустошения очереди при запуске, перед вызовом LTR35_StreamStart() блок данных уже должен быть предварительно загружен в буфер модуля через LTR35_Send(). После запуска необходимо при этом периодически подкачивать потоковые данные со скоростью не меньшей, чем скорость вывода.

Чтобы очередь в буфере модуля не переполнилась, в ltrd реализована логика контроля заполненности очереди модуля. Для реализации этой логики модуль высылает специальные статусные слова, которые предназначены для ltrd и не видны на уровне ltr35api (ltrd обрабатывает эти слова сам и не передает клиентам):
- При настройке модуля через LTR35_Configure() модуль высылает статус с настройками, необходимыми для отслеживания заполненности очереди. Также этот специальный статус сообщает ltrd, что очередь была очищена.
- При чтении каждых [StreamStatusPeriod](@ref TLTR35_CONFIG::StreamStatusPeriod) (значение 0 в настройках означает, что используется значение по-умолчанию) отсчетов из очереди модуль высылает периодический статус, в котором также содержатся признаки, были ли за это время события опустошения очереди или попытка передачи слов, когда очередь полностью заполнена.

В свою очередь ltrd отслеживает количество переданных отсчетов в модуль и по периодическим статусам подсчитывает количество вычитанных слов из буфера модуля. На основе этой информации ltrd знает на сколько отсчетов в очереди модуля еще есть свободного места (даже с учетом отправленных в крейт, но не дошедших до модуля отсчетов). Таким образом, ltrd посылает в модуль слов не больше, чем есть в буфере модуля свободного места.

При вызове LTR35_Send() слова передаются через буфер сокета канала обмена программы с ltrd в буфер ltrd. Из этого буфера, если в очереди модуля есть место, слова с максимальной скоростью интерфейса будут передаваться через буфер крейта в буфер модуля. При этом скорость будет ограничиваться сперва скоростью интерфейса ПК с крейтом, затем по заполнению буфера крейта --- скоростью интерфейса между крейтом и модулями. При заполнении буфера LTR35, ltrd будет ограничивать скорость передачи слов и поток передачи будет соответствовать скорости вывода отсчетов на ЦАП.

Таким образом, если пытаться передать данные в модуль с наибольшей скоростью, постоянно вызывая LTR35_Send(), то сперва заполнится буфер модуля, затем будет заполнен буфер ltrd, затем буфер сокета между ltrd и клиентом (программой, использующей ltr35api). При этом LTR35_Send() уже не будет возвращаться немедленно, а будет ожидать в течении заданного таймаута, пока освободится место в буфере сокета (при этом если раньше истечет таймаут, то не все данные могут быть переданы и возвращенное LTR35_Send() значение будет отличаться от запрошенного на передачу размера). Однако непрерывная выдача на ЦАП не прекратится и переполнения буфера и потерь отсчетов не будет.

Если нужно ручное управление занятостью очереди, то можно воспользоваться эхо-данными от одного из каналов модуля, о которых описано в разделе @ref sect_gen_cfg_echo.

Потоковый режим позволяет выводить непериодические сигналы (например, записанные сигналы из файла). Кроме того, потоковый режим позволяет работать с модулем LTR35 в асинхронном режиме, когда очередь почти всегда пуста и выводится последнее значение, а при необходимости изменения подготавливается и передается по одному слову на каждый канал с новыми значениями.


Режим циклического автогенератора{#sect_gen_mode_cycle}
-------------------------------------
Данный режим может использоваться для вывода периодического сигнала произвольной формы. В этом режиме набор сигналов (по одному сигналу на каждый канал) сперва загружается в страницу буфер модуля, после чего по вызову функции LTR35_SwitchCyclePage() модуль начинает выдавать загруженные данные данной страницы. При этом чтение станицы идет циклически по кругу и не требует дальнейшей загрузки данных. Как только будет прочитан последний записанный отсчет, в следующий период преобразования будут прочитаны отсчеты, загруженные первыми.

При выводе на несколько каналов сигналов с разными периодами нужно найти общий период всех сигналов как наименьшее общее кратное периодов каждого сигнала. При этом суммарное полученное число отсчетов не должно превышать #LTR35_MAX_POINTS_PER_PAGE.

В данном режиме память LTR35 разделена на два циклических буфера (две страницы). Это позволяет записывать новый набор сигналов не останавливая выдачу старого. Это выполняется аналогично записи первого набора. Т.е. после того как был записан первый набор сигналов и начата генерация сигналов с помощью LTR35_SwitchCyclePage(), то последующие вызовы LTR35_Send() будут передавать данные, которые будут записаны уже во вторую страницу. После того как второй набор сигналов будет записан полностью, нужно снова вызвать LTR35_SwitchCyclePage() для смены страниц. При этом смена произойдет в момент, когда вывод дойдет до конца первой страницы (т.е. для каждого канала первый отсчет нового сигнала будет выведен после последнего отсчета предыдущего). При этом ЦАП начнет выдавать сигнал с начала второй страницы, а первая снова будет доступна на запись. LTR35_SwitchCyclePage() возвращает управление, когда смена страницы уже будет завершена.

Особенности калибровки данных{#sect_gen_cbr}
===========================================================
Следует отметить, что калибровка данных выполняется аппаратно внутри модуля, а не программно. В связи с этим в LTR35_PrepareData() и LTR35_PrepareDacData() нет никаких указаний о выполнении калибровки. Самой библиотекой при открытии связи с модулем через LTR35_Open() выполняется чтение калибровочных коэффициентов из Flash-памяти модуля, сохранение их в полях массива [CbrCoef](@ref TINFO_LTR35::CbrCoef) в [структуре с информацией о модуле](@ref TLTR35::ModuleInfo). При конфигурации модуля с помощью LTR35_Configure() выполняется запись нужных коэффициентов (в зависимости от настроенного выхода для каждого канала) в ПЛИС.

ПЛИС налету выполняет калибровку по формуле \f$ Y = (X + Offset)*Scale \f$, где X --- 24-битный отсчет, передаваемый в модуль (или генерируемый одним из [арифметических генераторов](@ref sect_gen_cfg_arith)), Y --- калиброванный отсчет, который непосредственно записывается в ЦАП (и возвращается в [эхо-данных](@ref sect_gen_cfg_echo), если разрешено), Offset --- смещение шкалы (24-битный код), а Scale --- коэффициент шкалы для настроенного выхода соответствующего канала. 


Если пользователю необходимо установить свои калибровочные коэффициенты, то он должен изменить значение полей [CbrCoef](@ref TINFO_LTR35::CbrCoef) в [структуре с информацией о модуле](@ref TLTR35::ModuleInfo) перед вызовом LTR35_Configure().




