Общий подход к использованию интерфейсных функций{#sect_gen_descr}
==============================================================

  Общий алгоритм работы с модулем{#sect_gen_alg}
  ==============================================================

Данный раздел описывает типичную последовательность действий при работе с модулем LTR25. Более подробно каждый шаг будет описан в последующих разделах.

Типичная последовательность действий имеет следующий вид:
1. Создать экземпляр структуры TLTR25, представляющей собой описатель модуля. Описатель модуля содержит всю информацию о модуле и используется при вызове всех остальных функций.
2. Проинициализировать поля описателя с помощью LTR25_Init()
3. Установить соединение с интересующим модулем с помощью функции LTR25_Open().
4. Заполнить необходимые поля с настройками модуля подструктуры [Cfg](@ref TLTR25::Cfg) [описателя модуля](@ref TLTR25) и вызвать LTR25_SetADC(), для записи настроек в модуль.
5. Запуск сбора данных с помощью LTR25_Start().
7. Прием и обработка данных, как описано ниже
8. По завершению работы выполнить останов сбора данных с помощью LTR25_Stop().
9. Закрыть соединение с модулем, вызвав функцию LTR25_Close().
 

Типичный цикл приема и обработки данных аналогичен большинству модулей АЦП системы LTR и выглядит следующим образом:
1. Прием заданного количества отсчетов с помощью LTR25_Recv().
2. Обработка принятых отсчетов с помощью LTR25_ProcessData().




Настройка модуля{#sect_gen_cfg}
=============================================================
Настройка модуля выполняется аналогично большинству других модулей LTR: вначале значения всех параметров модуля записываются в соответствующие поля [структуры описателя модуля](@ref TLTR25), затем вызывается функция LTR25_SetADC(), которая значения этих полей передает модулю. Модуль должен быть настроен перед первым запуском сбора данных. Во время запущенного сбора данных изменение настроек не допускается.

Следует отметить, что все поля, относящиеся к настройке модуля, объединены в структуру типа #TLTR25_CONFIG (поле  [Cfg](@ref TLTR25::Cfg) [описателя модуля](@ref TLTR25)). Только эти поля пользователь должен изменять вручную в [описателе модуля](@ref TLTR25) при штатной работе и только эти поля влияют на параметры, записываемые LTR25_SetADC().

При настройке модуля задаются следующие параметры:
- Частота сбора АЦП. Может быть выбрана одна из 8 предопределенных частот сбора с помощью установки соответствующего кода в поле [FreqCode](@ref TLTR25_CONFIG::FreqCode).
- Настройки каналов АЦП (раздел @ref sect_gen_cfg_adc_ch)
- Формат передаваемых данных задается полем [DataFmt](@ref TLTR25_CONFIG::DataFmt). От формата зависит разрядность передаваемых отсчетов и количество передаваемых слов на один отсчет АЦП.
- Значение источника тока (10 или 2.86 мА) задается на все каналы сразу с помощью поля [ISrcValue](@ref TLTR25_CONFIG::ISrcValue).

После выполнения LTR25_SetADC() рассчитываются некоторые параметры, которые являются производными от настроек из #TLTR25_CONFIG. Эти параметры записываются в соответствующие поля структуры состояния модуля типа #TLTR25_STATE (поле [ State](@ref TLTR25::State) [описателя модуля](@ref TLTR25)). Например, на основе установленного кода частоты  в поле [AdcFreq](@ref TLTR25_STATE::AdcFreq) записывается соответствующая частота сбора АЦП в Гц.

Настройка каналов АЦП{#sect_gen_cfg_adc_ch}
--------------------------------------------------
Каждый модуль LTR25 имеет восемь каналов, которые выполняют преобразования параллельно. Можно разрешить запись как по любому набору из этих восьми каналов. Однако следует учитывать, что максимальное количество одновременно разрешенных каналов зависит от настроенной частоты сбора и формата отсчетов (подробнее см. в документе [\"Крейтовая система LTR. Руководство пользователя\"](http://www.lcard.ru/download/ltr.pdf) ).


Настройки каждого канала объединены в структуре #TLTR25_CHANNEL_CONFIG. Массив структур из #LTR25_CHANNEL_CNT элементов, каждый элемент которого соответствует нужному каналу, является полем [Ch](@ref TLTR25_CONFIG::Ch) структуры с [настройками модуля](@ref TLTR25::Cfg).

Для каждого канала можно независимо задать:
 - Разрешена ли запись по этому каналу. Задается полем [Enabled](@ref TLTR25_CHANNEL_CONFIG::Enabled).
 

 Проверка на обрыв или короткое замыкание {#sec_ch_status}
===========================================================
 Модуль LTR25 позволяет при запущенном сборе определять ситуации обрыва или короткого замыкания для каждого разрешенного канала. При определении одной из этих ситуаций в передаваемом слове вместо самого отсчета АЦП вставляется специальный код, сигнализирующий об возникновении события. Функция LTR25_ProcessData() анализирует эти коды и формирует для каждого разрешенного канала статус канала. Статус рассчитывается по всему блоку (но отдельно для каждого канала), то есть если хотя бы для одного отсчета из обрабатываемого блока был установлен признак обрыва, то будет возвращен статус этого канала #LTR25_CH_STATUS_OPEN. Порядок статусов соответствует порядку разрешенных каналов.
 
 Следует иметь ввиду, что определение состояний обрыва и КЗ --- процесс инерционный, и установка статусов выполняется с задержкой относительно реального события. Подробнее см.  в документе [\"Крейтовая система LTR. Руководство пользователя\"](http://www.lcard.ru/download/ltr.pdf).
 
 
 

Особенности калибровки данных модулем{#sect_gen_cbr}
===========================================================
Следует отметить, что в отличие от большинства остальных модулей LTR (например от LTR24), калибровка данных и коррекция АЧХ происходит аппаратно внутри модуля, а не программно. В связи с этим в LTR25_ProcessData() нет никаких указаний о выполнении калибровки. Самой библиотекой выполняется чтение калибровочных коэффициентов из Flash-памяти модуля, сохранение их в полях массива [CbrCoef](@ref TINFO_LTR25::CbrCoef) в [структуре с информацией о модуле](@ref TINFO_LTR25) и запись этих коэффициентов в ПЛИС.

Следует отметить, что калибровочные коээфициенты определяются и сохраняются отдельно для первых #LTR25_CBR_FREQ_CNT частот сбора. Так как остальные частоты получаются первых #LTR25_CBR_FREQ_CNT фильтрацией и прореживанием в ПЛИС, то для них используются коэффициенты исходной частоты. Для каждого из 8-ми каналов используются свои калибровочные коэффициенты.

ПЛИС налету выполняет калибровку по формуле \f$ Y = (X + Offset)*Gain \f$, где X --- отсчет с АЦП расширенный до 32-бит, Y --- калиброванные данные, Offset --- смещение шкалы (32-битный код), а Gain --- коэффициент шкалы. При этом перед выполнением калибровки, входное значение АЦП расширяется до 32-бит. На выходе получаются уже откалиброванные 32-битные отсчеты. В случае 32-битного формата эти отсчеты и передаются в крейт, а в случае 20-битного передаются только старшие 20-бит.

При этом код #LTR25_ADC_SCALE_CODE_MAX соответствует напряжению, равному максимальному напряжению для заданного диапазона.

Если пользователю необходимо установить свои калибровочные коэффициенты, то он должен изменить значение полей [CbrCoef](@ref TINFO_LTR25::CbrCoef) в [структуре с информацией о модуле](@ref TINFO_LTR25) перед вызовом LTR25_SetADC(), в которой и происходит загрузка коэффициентов в ПЛИС на основе установленной частоты АЦП.