#ifndef AD7176_H
#define AD7176_H


#define AD7176_ID_VAL   0x0C90
#define AD7176_ID_MASK  0xFFF0


#define AD7176_REG_STATUS       0x00
#define AD7176_REG_ADCMODE      0x01
#define AD7176_REG_IFMODE       0x02
#define AD7176_REG_REGCHECK     0x03
#define AD7176_REG_DATA         0x04
#define AD7176_REG_GPIOCON      0x06
#define AD7176_REG_ID           0x07
#define AD7176_REG_CHMAP(ch)    (BYTE)(0x10 + (ch))
#define AD7176_REG_SETUPCON(st) (BYTE)(0x20 + (st))
#define AD7176_REG_FILTCON(st)  (BYTE)(0x28 + (st))
#define AD7176_REG_OFFSET(st)   (BYTE)(0x30 + (st))
#define AD7176_REG_GAIN(st)     (BYTE)(0x38 + (st))



#define AD7176_REGBIT_COMMS_WEN         (0x1UL << 7)
#define AD7176_REGBIT_COMMS_RW          (0x1UL << 6)
#define AD7176_REGBIT_COMMS_RA          (0x3FUL << 0)

#define AD7176_REGBIT_STATUS_NRDY       (0x1UL << 7)
#define AD7176_REGBIT_STATUS_ADC_ERROR  (0x1UL << 6)
#define AD7176_REGBIT_STATUS_CRC_ERROR  (0x1UL << 5)
#define AD7176_REGBIT_STATUS_REG_ERROR  (0x1UL << 4)
#define AD7176_REGBIT_STATUS_CHANNEL    (0x3UL << 0)

#define AD7176_REGBIT_ADCMODE_REFEN     (0x1UL << 15)
#define AD7176_REGBIT_ADCMODE_SING_CYC  (0x1UL << 13)
#define AD7176_REGBIT_ADCMODE_DELAY     (0x7UL << 8)
#define AD7176_REGBIT_ADCMODE_MODE      (0x7UL << 4)
#define AD7176_REGBIT_ADCMODE_CLOCKSEL  (0x3UL << 2)

#define AD7176_REGBIT_IFMODE_ALT_SYNC   (0x1UL << 12)
#define AD7176_REGBIT_IFMODE_IOSTRENGTH (0x1UL << 11)
#define AD7176_REGBIT_IFMODE_HIDE_DELAY (0x1UL << 10)
#define AD7176_REGBIT_IFMODE_DOUT_RESET (0x1UL <<  8)
#define AD7176_REGBIT_IFMODE_CONTREAD   (0x1UL <<  7)
#define AD7176_REGBIT_IFMODE_DATA_STAT  (0x1UL <<  6)
#define AD7176_REGBIT_IFMODE_REG_CHECK  (0x1UL <<  5)
#define AD7176_REGBIT_IFMODE_CRC_EN     (0x3UL <<  2)
#define AD7176_REGBIT_IFMODE_WL16       (0x1UL <<  0)


#define AD7176_REGBIT_GPIOCON_MUX_IO    (0x1UL << 12)
#define AD7176_REGBIT_GPIOCON_SYNC_EN   (0x1UL << 11)
#define AD7176_REGBIT_GPIOCON_ERR_EN    (0x3UL <<  9)
#define AD7176_REGBIT_GPIOCON_ERR_DAT   (0x1UL <<  8)
#define AD7176_REGBIT_GPIOCON_IP_EN1    (0x1UL <<  5)
#define AD7176_REGBIT_GPIOCON_IP_EN0    (0x1UL <<  4)
#define AD7176_REGBIT_GPIOCON_OP_EN1    (0x1UL <<  3)
#define AD7176_REGBIT_GPIOCON_OP_EN0    (0x1UL <<  2)
#define AD7176_REGBIT_GPIOCON_GP_DATA1  (0x1UL <<  1)
#define AD7176_REGBIT_GPIOCON_GP_DATA0  (0x1UL <<  0)


#define AD7176_REGBIT_CHMAP_CH_EN       (0x1UL << 15)
#define AD7176_REGBIT_CHMAP_SETUP_SEL   (0x3UL << 12)
#define AD7176_REGBIT_CHMAP_AINPOS      (0x1FUL << 5)
#define AD7176_REGBIT_CHMAP_AINNEG      (0x1FUL << 0)

#define AD7176_REGBIT_SETUPCON_BIPOLAR  (0x1UL << 12)
#define AD7176_REGBIT_SETUPCON_REF_SEL  (0x3UL <<  4)

#define AD7176_REGBIT_FILTCON_SINC3_MAP (0x1UL << 15)
#define AD7176_REGBIT_FILTCON_ENHFILTEN (0x1UL << 11)
#define AD7176_REGBIT_FILTCON_ENHFILT   (0x7UL <<  8)
#define AD7176_REGBIT_FILTCON_ORDER     (0x3UL <<  5)
#define AD7176_REGBIT_FILTCON_ODR       (0x1FUL << 0)




#define AD7176_MODE_CONTINUOUS      0
#define AD7176_MODE_SINGLE          1
#define AD7176_MODE_STANDBY         2
#define AD7176_MODE_POWERDOWN       3
#define AD7176_MODE_CBR_INT_OFFSET  4
#define AD7176_MODE_CBR_SYS_OFFSET  6
#define AD7176_MODE_CBR_SYS_GAIN    7

#define AD7176_CLOCKSEL_INT         0
#define AD7176_CLOCKSEL_INT_OUT     1
#define AD7176_CLOCKSEL_EXT_CLOCK   2
#define AD7176_CLOCKSEL_EXT_CRYSTAL 3


#define AD7176_AIN_0        0
#define AD7176_AIN_1        1
#define AD7176_AIN_2        2
#define AD7176_AIN_3        3
#define AD7176_AIN_4        4
#define AD7176_AIN_REFPOS   0x15
#define AD7176_AIN_REFNEG   0x16

#define AD7176_REFSEL_EXT_REF   0
#define AD7176_REFSEL_INT_REF   2
#define AD7176_REFSEL_AVDD      3

#define AD7176_FLT_ORDER_SINC5_1 0
#define AD7176_FLT_ORDER_SINC3   3

#define AD7176_ODR250       0
#define AD7176_ODR125       1
#define AD7176_ODR62_5      2
#define AD7176_ODR50        3
#define AD7176_ODR31_25     4
#define AD7176_ODR25        5
#define AD7176_ODR15_625    6
#define AD7176_ODR10        7
#define AD7176_ODR5         8
#define AD7176_ODR2_5       9
#define AD7176_ODR1         10
#define AD7176_ODR0_5       11
#define AD7176_ODR0_3975    12
#define AD7176_ODR0_2       13
#define AD7176_ODR0_1       14
#define AD7176_ODR0_05994   15
#define AD7176_ODR0_04996   16
#define AD7176_ODR0_02      17
#define AD7176_ODR0_016667  18
#define AD7176_ODR0_01      19
#define AD7176_ODR0_005     20


#endif // AD7176_H



