#ifndef LBITFIELD_H
#define LBITFIELD_H

/* Вычисление позиции по битовой маске, т.е. младшего значащего бита в ненулевом числе
 * = pow(2, n), где n - количество нулевых младших разрядов */
#define LBITFIELD_LSB(mask)                ((unsigned)((mask) & ~((mask) - 1)))

/* Заполнение поля по битовой маске */
#define LBITFIELD_SET(mask, val)           ((mask) & ((val) * LBITFIELD_LSB(mask)))
/* Извлечение значения поля по битовой маске */
#define LBITFIELD_GET(mask, word)          (((word) / LBITFIELD_LSB(mask)) & ((mask) / LBITFIELD_LSB(mask)))

#endif // LBITFIELDS_H
