#ifndef FLASH_DEV_AT25SF_H
#define FLASH_DEV_AT25SF_H


#include "flash.h"

#ifdef __cplusplus
extern "C" {
#endif


#define AT25SF_ID_MANUFACTURER  0x1F
#define AT25SF_ID_DEVICE        0x84
#define AT25SF_ID_CAPACITY      0x01

#define AT25SF_FLASH_SIZE       (512*1024)

typedef enum {
    AT25SF_STATUS_BSY   = 1UL << 0, /* busy status */
    AT25SF_STATUS_WEL   = 1UL << 1, /* write enable latch */
    AT25SF_STATUS_BP0   = 1UL << 2, /* block protection bit-1 */
    AT25SF_STATUS_BP1   = 1UL << 3, /* block protection bit-2 */
    AT25SF_STATUS_BP2   = 1UL << 4, /* block protection bit-2 */
    AT25SF_STATUS_TB    = 1UL << 5, /* top or bottom protection */
    AT25SF_STATUS_SEC   = 1UL << 6, /* block protection */
    AT25SF_STATUS_SRP0  = 1UL << 7,  /* status register protection bit-0 */
    /* extended status2 bits */
    AT25SF_STATUS_SRP1 = 1UL << 8, /* status register protection bit-1 */
    AT25SF_STATUS_QE   = 1UL << 9, /* quad enable */
    AT25SF_STATUS_LB1  = 1UL << 11, /* lock security register 1 */
    AT25SF_STATUS_LB2  = 1UL << 12, /* lock security register 2 */
    AT25SF_STATUS_LB3  = 1UL << 13, /* lock security register 3 */
    AT25SF_STATUS_CMP  = 1UL << 14, /* complement block protection */
} t_flash_at25sf_status;


extern const t_flash_info flash_info_at25sf;

t_flash_errs flash_at25sf_set(t_flash_iface *iface);
/* получение расширенного статуса из 2-х байт (status2 в старшей половине) */
t_flash_errs flash_at25sf_get_status_ex(t_flash_iface *iface, unsigned short *status);
t_flash_errs flash_at25sf_set_status_ex(t_flash_iface *iface, unsigned short status);



#define flash_at25sf_get_status     flash_generic_get_status
#define flash_at25sf_read           flash_generic_read
#define flash_at25sf_erase          flash_generic_erase
#define flash_at25sf_write          flash_generic_write
#define flash_at25sf_write_enable   flash_generic_write_enable

#ifdef __cplusplus
}
#endif


#endif // FLASH_DEV_AT25SF_H

