#include "flash_dev_at25sf.h"

#define AT25SF_FLASH_CMD_READ_STATUS2   0x35

static const t_flash_erase_cmd f_erase_cmds[] = {
    {FLASH_CMD_CODE_ERASE_64K,           64*1024,  2200},
    {FLASH_CMD_CODE_ERASE_32K,           32*1024,  1300},
    {FLASH_CMD_CODE_ERASE_4K,               4096,   300},
    {0,0,0}
};

const t_flash_info flash_info_at25sf =  {
    {AT25SF_ID_MANUFACTURER, AT25SF_ID_DEVICE, AT25SF_ID_CAPACITY, FLASH_ID_EDI_LEN_NOT_SUPPORTED},
    AT25SF_FLASH_SIZE,
    {FLASH_CMD_CODE_READ_STATUS, AT25SF_STATUS_BSY, 0x0, 0x0},
    {FLASH_CMD_CODE_READ, 0},
    {f_erase_cmds, FLASH_CMD_CODE_WRITE_ENABLE},
    {0x100, FLASH_CMD_CODE_PAGE_PROGRAM, 2500},
    {   NULL,
        flash_at25sf_get_status,
        flash_at25sf_read,
        flash_at25sf_erase,
        flash_at25sf_write,
        flash_at25sf_write_enable,
        NULL,
        NULL,
        NULL
    }
};


t_flash_errs flash_at25sf_get_status_ex(t_flash_iface *iface, unsigned short *status) {
    unsigned char status1, status2;
    t_flash_errs err = 0;

    err = flash_get_status(iface, &status1);
    if (!err) {
        unsigned char cmd = AT25SF_FLASH_CMD_READ_STATUS2;
        err = flash_exec_cmd(iface, &cmd, 1, NULL,0, &status2, 1, FLASH_FLAGS_FLUSH);
    }

    if (!err && (status != NULL))  {
        *status = (status2 << 8) | status1;
    }
    return err;
}

t_flash_errs flash_at25sf_set_status_ex(t_flash_iface *iface, unsigned short status) {
    t_flash_errs err = 0;
    if (iface->flash_info != &flash_info_at25sf)
        err = FLASH_ERR_INVALID_DEVICE;

    if (!err)
        err = flash_write_enable(iface);

    if (!err) {
        unsigned char cmd = FLASH_CMD_CODE_WRITE_STATUS;
        unsigned char status_byts[2] = {status & 0xFF, (status >> 8) & 0xFF};
        err = flash_exec_cmd(iface, &cmd, 1, status_byts, 2, NULL, 0, FLASH_FLAGS_FLUSH);
    }
    return err;
}
