#include "flash_dev_at25df.h"

static const t_flash_erase_cmd f_erase_cmds[] = {
    {FLASH_CMD_CODE_ERASE_64K,  64*1024,  950},
    {FLASH_CMD_CODE_ERASE_32K,  32*1024,  600},
    {FLASH_CMD_CODE_ERASE_4K,      4096,  200},
    {0,0,0}
};

const t_flash_info flash_info_at25df =  {
    {AT25DF_ID_MANUFACTURER, AT25DF_ID_DEVICE, AT25DF_ID_CAPACITY, 0},
    AT25DF_FLASH_SIZE,
    {FLASH_CMD_CODE_READ_STATUS, AT25DF_STATUS_BSY, 0x0, AT25DF_STATUS_EPE},
    {FLASH_CMD_CODE_READ, 0},
    {f_erase_cmds, FLASH_CMD_CODE_WRITE_ENABLE},
    {0x100, FLASH_CMD_CODE_PAGE_PROGRAM, 5000},
    {   NULL,
        flash_at25df_get_status,
        flash_at25df_read,
        flash_at25df_erase,
        flash_at25df_write,
        flash_at25df_write_enable,
        NULL,
        NULL,
        NULL
    }
};

t_flash_errs flash_at25df_set(t_flash_iface *iface) {
    return flash_set(iface, &flash_info_at25df);
}


t_flash_errs flash_at25df_set_status(t_flash_iface *iface, unsigned char status) {
    t_flash_errs err = 0;
    if (iface->flash_info != &flash_info_at25df)
        err = FLASH_ERR_INVALID_DEVICE;

    if (!err)
        err = flash_write_enable(iface);

    if (!err) {
        unsigned char cmd = FLASH_CMD_CODE_WRITE_STATUS;
        err = flash_exec_cmd(iface, &cmd, 1, &status, 1, NULL, 0, FLASH_FLAGS_FLUSH);
    }
    return err;
}


t_flash_errs flash_at25df_global_unprotect(t_flash_iface *iface) {
    return flash_at25df_set_status(iface, 0);
}

t_flash_errs flash_at25df_global_protect(t_flash_iface *iface) {
    return flash_at25df_set_status(iface, 0x3C);
}
