#ifndef LQMEAS_DEVADCCONFIG_H
#define LQMEAS_DEVADCCONFIG_H

#include "DevAdcInfo.h"
#include <QVector>
#include "lqmeas/units/Units.h"

namespace LQMeas {
    class DevAdcConfig {
    public:
        DevAdcConfig(const DevAdcInfo *info);
        DevAdcConfig(const DevAdcConfig *cfg);

        const DevAdcInfo *adcInfo() const {return m_adc_info;}

        virtual double adcFreq() const = 0;
        virtual double adcChFreq() const;
        /* начальное смещение по времени заданного канала АЦП относительно первого канала */
        virtual double adcChTimeShift(int ch) const;

        virtual bool adcChEnabled(int ch) const = 0;
        virtual bool adcExternalStart() const {return false;}

        virtual unsigned  adcEnabledChCnt() const {return m_ch_indexes.size();}

        virtual int adcChRangeNum(int ch) const = 0;
        virtual double adcChRangeMaxVal(int ch) const {
            return adcInfo()->adcRangeMaxVal(adcChRangeNum(ch), adcUnitMode(ch));
        }
        virtual double adcChRangeMinVal(int ch) const {
            return adcInfo()->adcRangeMinVal(adcChRangeNum(ch), adcUnitMode(ch));
        }

        virtual int adcUnitMode(int ch) const {return 0;}
        virtual const Unit *adcChUnit(int ch) const {
            return m_adc_info->adcChUnit(ch, adcUnitMode(ch));
        }


        /* получить номер физ. канала по индексу при приеме */
        virtual int adcChNum(int idx) const;
        virtual int adcChIdx(int ch) const;
    private:
        void adcUpdateConfig() const;
        void adcUpdateDevInfo(const DevAdcInfo *info);
        const DevAdcInfo *m_adc_info;
        mutable QVector<int> m_ch_indexes;

        friend class DeviceConfig;
    };
}

#endif // LQMEAS_DEVADCCONFIG_H
