#ifdef _WIN32
    #include "Windows.h"
    typedef HANDLE t_com_hnd;
#else
    typedef int t_com_hnd;
#endif


#define COM_ERR_OPEN             -1
#define COM_ERR_READ             -2
#define COM_ERR_WRITE            -3
#define COM_ERR_READ_RESULT      -4
#define COM_ERR_WRITE_RESULT     -5
#define COM_ERR_TIMEOUT          -6
#define COM_ERR_CLOSE            -7
#define COM_ERR_GET_SETTINGS     -8
#define COM_ERR_SET_SETTINGS     -9
#define COM_ERR_ALLOC_RESOURCE   -10
#define COM_ERR_RESET            -11



#define COM_PARITY_NONE     0
#define COM_PARITY_ODD      1
#define COM_PARITY_EVEN     2


#define COM_SET_FLAGS_TWO_STOP_BITS    0x0001
#define COM_SET_FLAGS_DTR_CTL_EN       0x0100
#define COM_SET_FLAGS_RTS_CTL_EN       0x0400


t_com_hnd com_open(const char* filename);
int com_close(t_com_hnd port);
int com_read(t_com_hnd port, unsigned char* buff, int size, int timeout);
int com_write(t_com_hnd port, unsigned char* buff, int size, int timeout);
int com_reset(t_com_hnd port);
int com_set_br(t_com_hnd port, int br, int parity, int flags);
