#ifndef CANAPI_H_
#define CANAPI_H_

#include "stdint.h"


typedef enum
{
    CAN_ERR_INVALID_HANDLE    = -1000,
    CAN_ERR_INVALID_INTERFACE = -1001,
    CAN_ERR_COM_WRITE         = -1002,
    CAN_ERR_COM_READ          = -1003,
    CAN_ERR_RX_CRC            = -1004
} t_can_errs;




/** Константы для задания частоты на шине CAN (в соответствии с LSS)*/
#define CAN_BR_1000   0
#define CAN_BR_800    1
#define CAN_BR_500    2
#define CAN_BR_250    3
#define CAN_BR_125    4
#define CAN_BR_50     6
#define CAN_BR_20     7
#define CAN_BR_10     8

/** Максимальный размер данных в пакете CAN */
#define CAN_MAX_DATA_SIZE  8

/** флаги, описывающие передаваемое сообщение по CAN-интерфейсу */
typedef enum
{
    CAN_MSG_FLAGS_RTR = 0x01,  /**< указывает, что посылка является запросом
                                на передачу, а не самой передачей */
    CAN_MSG_FLAGS_EXT_FMT = 0x02 /**< указывает, что используется расширенный
                                     29-битный ID в CAN-сообщении */
} t_can_msg_falgs;


/** структура, описывающая передаваемое или принимаемое CAN-сообщение */
typedef struct
{
    uint32_t id;     /**< ID-сообщения (29 или 11 битный) */
    uint8_t  len;    /**< Длина сообщения (0-8) */
    uint8_t  flags;  /**< Флаги из #t_can_msg_falgs */
    uint8_t  data[CAN_MAX_DATA_SIZE]; /**< Передаваемые данные */
} t_can_msg;


struct st_can_state;
typedef struct st_can_state* t_can_hnd;



t_can_hnd can_open_rs(const char* port);
int can_send_msg(t_can_hnd hnd, const t_can_msg* msg);
int can_recv_msg(t_can_hnd hnd, t_can_msg* msg, int tout);
int can_set_speed(t_can_hnd hnd, unsigned char spd);
int can_set_filter(t_can_hnd hnd, unsigned int id);




#endif


