#ifndef LBOOT_MBRTU_H
#define LBOOT_MBRTU_H

#include "lboot.h"



#define LBOOT_OPT_MB_PORT       0x12000
#define LBOOT_OPT_MB_ADDR       0x12001
#define LBOOT_OPT_MB_BR         0x12002
#define LBOOT_OPT_MP_PARITY     0x12003

/** опции для задания параметров соединения по пртротоколу modbus rtu */
#define MBRTU_OPTIONS  {"mb-port",    required_argument,   0, LBOOT_OPT_MB_PORT}, \
                       {"mb-addr",    required_argument,   0, LBOOT_OPT_MB_ADDR}, \
                       {"mb-baudrate", required_argument,  0, LBOOT_OPT_MB_BR}, \
                       {"mb-parity",    required_argument, 0, LBOOT_OPT_MP_PARITY},


/** максимальный размер блока */
#define LBOOT_MBRTU_MAX_BLOCK_SIZE  200

int lboot_mbrtu_parse_option(int opt);
const char* lboot_mbrtu_get_opt_descr(void);
const char* lboot_mbrtu_get_err_str(int err);
int lboot_mbrtu_open(const char* devname, const char* serial, const void* params,
                   t_lboot_devinfo* info, int* out);
int lboot_mbrtu_get_devmode(uint8_t* mode);
int lboot_mbrtu_get_bootloader_version(uint16_t* ver);
int lboot_mbrtu_get_dev_flags(uint32_t* flags);
int lboot_mbrtu_get_features(uint32_t* flags);
int lboot_mbrtu_start_write(t_lboot_startwr_info wr_info);
int lboot_mbrtu_write(const uint8_t* buf, uint32_t size);
int lboot_mbrtu_write_sign(const uint8_t* sign, uint32_t size);
int lboot_mbrtu_speccmd(const t_lboot_speccmd_info* cmd_info, uint32_t size);
int lboot_mbrtu_close(void);





#endif // LBOOT_MBRTU_H
