/*================================================================================================*
 *   CRC-16  CRC-32    
 *================================================================================================*/

#ifndef FAST_CRC_H_
#define FAST_CRC_H_

#include "fast_crc_cfg.h"

/*================================================================================================*/
/*  CRC16 (CCITT, 0x1021) */
#if FASTCRC_CRC16_ADD8
/*------------------------------------------------------------------------------------------------*/
FASTCRC_U16_TYPE CRC16_Add8         /*   */
    (
    FASTCRC_U16_TYPE crc,           /* ()  -   */
    FASTCRC_U8_TYPE byte            /* ()  -  */
    );
/*------------------------------------------------------------------------------------------------*/
#endif

#if FASTCRC_CRC16_ADD16
/*------------------------------------------------------------------------------------------------*/
FASTCRC_U16_TYPE CRC16_Add16        /*  16-  (  ) */
    (
    FASTCRC_U16_TYPE crc,           /* ()  -   */
    FASTCRC_U16_TYPE word           /* ()  -  */
    );
/*------------------------------------------------------------------------------------------------*/
#endif

#if FASTCRC_CRC16_BLOCK8
/*------------------------------------------------------------------------------------------------*/
FASTCRC_U16_TYPE CRC16_Block8       /*  CRC16   */
    (
    FASTCRC_U16_TYPE crc,           /* ()  -   */
    const FASTCRC_U8_TYPE* pdata,   /* ()  -  */
    FASTCRC_SIZE_TYPE num_bytes     /* ()  -   */
    );
/*------------------------------------------------------------------------------------------------*/
#endif

#if FASTCRC_CRC16_BLOCK16
/*------------------------------------------------------------------------------------------------*/
FASTCRC_U16_TYPE CRC16_Block16      /*  CRC16  16-  */
    (
    FASTCRC_U16_TYPE crc,           /* ()  -   */
    const FASTCRC_U16_TYPE* pdata,  /* ()  -  */
    FASTCRC_SIZE_TYPE num_words     /* ()  -   */
    );
/*------------------------------------------------------------------------------------------------*/
#endif

/*  CRC32 (CCITT) */
#if FASTCRC_CRC32_BLOCK8
/*------------------------------------------------------------------------------------------------*/
FASTCRC_U32_TYPE CRC32_Block8       /*  CRC32   */
    (
    FASTCRC_U32_TYPE crc,           /* ()  -   (   0) */
    const FASTCRC_U8_TYPE* pdata,   /* ()  -  */
    FASTCRC_SIZE_TYPE num_bytes     /* ()  -   */
    );
/*------------------------------------------------------------------------------------------------*/
#endif
/*================================================================================================*/

#endif /* FAST_CRC_H_ */
