/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai;

import com.lightcrafts.media.jai.util.PropertyUtil;
import com.lightcrafts.mediax.jai.JaiI18N;
import com.lightcrafts.mediax.jai.PropertyChangeSupportJAI;
import com.lightcrafts.mediax.jai.RenderedImageAdapter;
import com.lightcrafts.mediax.jai.WritablePropertySource;
import com.lightcrafts.mediax.jai.WritablePropertySourceImpl;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public final class RenderableImageAdapter
implements RenderableImage,
WritablePropertySource {
    private RenderableImage im;
    private PropertyChangeSupportJAI eventManager = null;
    private WritablePropertySourceImpl properties = null;

    public static RenderableImageAdapter wrapRenderableImage(RenderableImage im) {
        if (im == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (im instanceof RenderableImageAdapter) {
            return (RenderableImageAdapter)im;
        }
        return new RenderableImageAdapter(im);
    }

    public RenderableImageAdapter(RenderableImage im) {
        if (im == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.im = im;
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
    }

    public final RenderableImage getWrappedImage() {
        return this.im;
    }

    public final Vector getSources() {
        return this.im.getSources();
    }

    @Override
    public final Object getProperty(String name) {
        Object property = this.properties.getProperty(name);
        if (property == Image.UndefinedProperty) {
            property = this.im.getProperty(name);
        }
        return property;
    }

    @Override
    public Class getPropertyClass(String name) {
        Object propValue;
        Class<?> propClass = this.properties.getPropertyClass(name);
        if (propClass == null && (propValue = this.getProperty(name)) != Image.UndefinedProperty) {
            propClass = propValue.getClass();
        }
        return propClass;
    }

    @Override
    public final String[] getPropertyNames() {
        return RenderedImageAdapter.mergePropertyNames(this.properties.getPropertyNames(), this.im.getPropertyNames());
    }

    @Override
    public String[] getPropertyNames(String prefix) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), prefix);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void removeProperty(String name) {
        this.properties.removeProperty(name);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.eventManager.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.eventManager.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.eventManager.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.eventManager.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public final float getWidth() {
        return this.im.getWidth();
    }

    @Override
    public final float getHeight() {
        return this.im.getHeight();
    }

    @Override
    public final float getMinX() {
        return this.im.getMinX();
    }

    @Override
    public final float getMinY() {
        return this.im.getMinY();
    }

    @Override
    public final boolean isDynamic() {
        return this.im.isDynamic();
    }

    @Override
    public final RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
        return this.im.createScaledRendering(w, h, hints);
    }

    @Override
    public final RenderedImage createDefaultRendering() {
        return this.im.createDefaultRendering();
    }

    @Override
    public final RenderedImage createRendering(RenderContext renderContext) {
        return this.im.createRendering(renderContext);
    }
}

