/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.codecimpl;

import com.lightcrafts.media.jai.codec.ImageCodec;
import com.lightcrafts.media.jai.codec.ImageDecodeParam;
import com.lightcrafts.media.jai.codec.ImageDecoder;
import com.lightcrafts.media.jai.codec.ImageEncodeParam;
import com.lightcrafts.media.jai.codec.ImageEncoder;
import com.lightcrafts.media.jai.codec.SeekableStream;
import com.lightcrafts.media.jai.codec.TIFFDecodeParam;
import com.lightcrafts.media.jai.codec.TIFFEncodeParam;
import com.lightcrafts.media.jai.codecimpl.TIFFImageDecoder;
import com.lightcrafts.media.jai.codecimpl.TIFFImageEncoder;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class TIFFCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "tiff";
    }

    @Override
    public Class getEncodeParamClass() {
        return TIFFEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return TIFFDecodeParam.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return true;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        return new TIFFImageEncoder(dst, param);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new TIFFImageDecoder(src, param);
    }

    @Override
    public int getNumHeaderBytes() {
        return 4;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        if (header[0] == 73 && header[1] == 73 && header[2] == 42 && header[3] == 0) {
            return true;
        }
        return header[0] == 77 && header[1] == 77 && header[2] == 0 && header[3] == 42;
    }
}

