/*
 * Decompiled with CFR 0.152.
 */
package tilecachetool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public final class EventViewer
extends JPanel {
    private JTable table;
    private DefaultTableModel model;
    private JScrollPane scrollpane;
    private Object[][] initial_data = new Object[][]{{"-", "-", "-", "-"}};
    private static final Color LIGHT_BLUE = new Color(240, 240, 255);
    private static final Font TABLE_FONT = new Font("monospaced", 1, 12);
    private static final String[] COLUMN_LABELS = new String[]{"JAI Operator", "Event", "Tile Size", "Timestamp"};

    public EventViewer() {
        this.setLayout(new FlowLayout(0, 1, 1));
        this.model = new DefaultTableModel(this.initial_data, COLUMN_LABELS);
        this.table = new JTable(this.model);
        this.table.setFont(TABLE_FONT);
        this.table.setBackground(LIGHT_BLUE);
        this.table.setAutoResizeMode(4);
        this.table.setAutoscrolls(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.setHorizontalScrollBarPolicy(31);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        EmptyBorder empty_border = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bevel_border = new BevelBorder(1);
        this.scrollpane.setBorder(new CompoundBorder(empty_border, bevel_border));
        Dimension dim = new Dimension(this.scrollpane.getPreferredSize().width + 100, 140);
        this.scrollpane.setPreferredSize(dim);
        this.add(this.scrollpane);
    }

    public void setRows(int rows) {
        if (rows <= 0) {
            throw new IllegalArgumentException("rows must be greater than 0.");
        }
        int hdr_height = (int)this.table.getTableHeader().getHeaderRect(0).getHeight();
        int height = this.table.getRowHeight() * (rows + 1) + hdr_height;
        Dimension dim = new Dimension(this.scrollpane.getPreferredSize().width, height);
        this.scrollpane.setPreferredSize(dim);
        this.scrollpane.revalidate();
    }

    public void clear() {
        int count;
        for (int i = count = this.model.getRowCount() - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
        this.model = new DefaultTableModel(this.initial_data, COLUMN_LABELS);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(90);
    }

    public synchronized void insertRow(int row, Vector data) {
        if (row < 0) {
            throw new IllegalArgumentException("Rows must be greater or equal to 0.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.model.insertRow(row, data);
    }
}

