/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.xml;

import com.lightcrafts.utils.xml.Base64;
import com.lightcrafts.utils.xml.XMLException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlNode {
    private static final String VersionTag = "version";
    private Element element;
    private ArrayList<XmlNode> children;

    XmlNode(Element element) {
        this.element = element;
        this.children = new ArrayList();
        NodeList nodes = element.getChildNodes();
        for (int n = 0; n < nodes.getLength(); ++n) {
            Node node = nodes.item(n);
            if (node.getNodeType() != 1) continue;
            XmlNode child = new XmlNode((Element)node);
            this.children.add(child);
        }
    }

    public int getVersion() {
        Node e = this.element;
        while (e instanceof Element) {
            String s = e.getAttribute(VersionTag);
            if (s != null) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            e = e.getParentNode();
        }
        return -1;
    }

    public void setVersion(int version) {
        this.setAttribute(VersionTag, Integer.toString(version));
    }

    public String getName() {
        return this.element.getTagName();
    }

    public boolean hasAttribute(String key) {
        return this.element.hasAttribute(key);
    }

    public String getAttribute(String key) throws XMLException {
        if (!this.hasAttribute(key)) {
            String message = "Expected attribute \"" + key + "\" under \"" + this.getName() + "\"";
            throw new XMLException(message);
        }
        String value = this.element.getAttribute(key);
        return value;
    }

    public void setAttribute(String key, String value) {
        this.element.setAttribute(key, value);
    }

    public String[] getAttributes() {
        NamedNodeMap map = this.element.getAttributes();
        int length = map.getLength();
        String[] keys = new String[length];
        for (int n = 0; n < length; ++n) {
            Node item = map.item(n);
            keys[n] = item.getNodeName();
        }
        return keys;
    }

    public XmlNode addChild(String name) {
        Document doc = this.element.getOwnerDocument();
        Element e = doc.createElement(name);
        this.element.appendChild(e);
        XmlNode child = new XmlNode(e);
        this.children.add(child);
        return child;
    }

    public boolean hasChild(String name) {
        for (XmlNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public XmlNode getChild(String name) throws XMLException {
        for (XmlNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        String message = "Expected child \"" + name + "\" under \"" + this.getName() + "\"";
        throw new XMLException(message);
    }

    public XmlNode[] getChildren() {
        return this.children.toArray(new XmlNode[0]);
    }

    public XmlNode[] getChildren(String name) {
        ArrayList<XmlNode> nameChildren = new ArrayList<XmlNode>();
        for (XmlNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            nameChildren.add(child);
        }
        return nameChildren.toArray(new XmlNode[0]);
    }

    public void removeChild(XmlNode child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            this.element.removeChild(child.element);
        }
    }

    public void setData(byte[] data) {
        String s = Base64.encodeBytes(data);
        this.clearData();
        Document doc = this.element.getOwnerDocument();
        Text text = doc.createTextNode(s);
        this.element.appendChild(text);
    }

    public byte[] getData() {
        StringBuilder sb = new StringBuilder();
        NodeList nodes = this.element.getChildNodes();
        for (int n = 0; n < nodes.getLength(); ++n) {
            Node node = nodes.item(n);
            if (node.getNodeType() != 3) continue;
            Text text = (Text)node;
            sb.append(text.getData());
        }
        return Base64.decode(sb.toString());
    }

    public void clearData() {
        NodeList nodes = this.element.getChildNodes();
        int i = nodes.getLength() - 1;
        Node node;
        while ((node = nodes.item(i)) != null) {
            if (node.getNodeType() == 3) {
                this.element.removeChild(node);
                continue;
            }
            --i;
        }
        return;
    }
}

