/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.utils.filecache.FileCacheKeyMapper;
import java.io.File;

public final class LocalFileCacheKeyMapper
implements FileCacheKeyMapper {
    private final File m_cacheDir;

    public static LocalFileCacheKeyMapper create(File cacheDir) {
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            return null;
        }
        return new LocalFileCacheKeyMapper(cacheDir);
    }

    @Override
    public File getCacheDirectory() {
        return this.m_cacheDir;
    }

    @Override
    public File mapKeyToFile(String key, boolean ensurePathExists) {
        int sep = key.lastIndexOf(File.separatorChar);
        if (sep >= 0) {
            key = key.substring(sep + 1);
        }
        return new File(this.m_cacheDir, key + ".lzc");
    }

    private LocalFileCacheKeyMapper(File cacheDir) {
        this.m_cacheDir = cacheDir;
    }
}

