/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.file;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class OrderableRandomAccessFile
implements Closeable,
DataInput,
DataOutput {
    private RandomAccessFile m_file;
    private ByteOrder m_order;

    public OrderableRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this(new RandomAccessFile(file, mode));
    }

    public OrderableRandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        this(new RandomAccessFile(fileName, mode));
    }

    public OrderableRandomAccessFile(RandomAccessFile file) {
        this(file, ByteOrder.BIG_ENDIAN);
    }

    public OrderableRandomAccessFile(RandomAccessFile file, ByteOrder order) {
        this.m_file = file;
        this.m_order = order;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.m_file != null) {
            this.m_file.close();
            this.m_file = null;
        }
    }

    public FileChannel getChannel() {
        return this.m_file.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.m_file.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.m_file.getFilePointer();
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.m_file;
    }

    public long length() throws IOException {
        return this.m_file.length();
    }

    public ByteOrder order() {
        return this.m_order;
    }

    public void order(ByteOrder order) {
        this.m_order = order;
    }

    public int read() throws IOException {
        return this.m_file.read();
    }

    public int read(byte[] b) throws IOException {
        return this.m_file.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.m_file.read(b, off, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.m_file.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.m_file.readByte();
    }

    @Override
    public char readChar() throws IOException {
        char c = this.m_file.readChar();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            c = Character.reverseBytes(c);
        }
        return c;
    }

    @Override
    public double readDouble() throws IOException {
        long n = this.m_file.readLong();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Long.reverseBytes(n);
        }
        return Double.longBitsToDouble(n);
    }

    @Override
    public float readFloat() throws IOException {
        int n = this.m_file.readInt();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Integer.reverseBytes(n);
        }
        return Float.intBitsToFloat(n);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.m_file.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.m_file.readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        int n = this.m_file.readInt();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Integer.reverseBytes(n);
        }
        return n;
    }

    @Override
    public String readLine() throws IOException {
        return this.m_file.readLine();
    }

    @Override
    public long readLong() throws IOException {
        long n = this.m_file.readLong();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Long.reverseBytes(n);
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        short n = this.m_file.readShort();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Short.reverseBytes(n);
        }
        return n;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.m_file.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n = this.m_file.readUnsignedShort();
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Short.reverseBytes((short)n);
        }
        return n & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        return this.m_file.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.m_file.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        this.m_file.setLength(newLength);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.m_file.skipBytes(n);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.m_file.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.m_file.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.m_file.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.m_file.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.m_file.writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.m_file.writeBytes(s);
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            v = Short.reverseBytes((short)v);
        }
        this.m_file.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long n = Double.doubleToLongBits(v);
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Long.reverseBytes(n);
        }
        this.m_file.writeLong(n);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int n = Float.floatToIntBits(v);
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            n = Integer.reverseBytes(n);
        }
        this.m_file.writeInt(n);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        this.m_file.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        this.m_file.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.m_order == ByteOrder.LITTLE_ENDIAN) {
            v = Short.reverseBytes((short)v);
        }
        this.m_file.writeShort(v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.m_file.writeUTF(s);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

