/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import java.io.IOException;
import java.nio.ByteOrder;

public abstract class LCByteBuffer {
    private final int m_capacity;
    private int m_initialOffset;
    private int m_limit;
    private int m_position;

    public final int capacity() {
        return this.m_capacity;
    }

    public final byte get() throws IOException {
        int origPos = this.m_position;
        byte result = this.get(this.m_position);
        this.m_position = origPos + 1;
        return result;
    }

    public abstract byte get(int var1) throws IOException;

    public abstract LCByteBuffer get(byte[] var1, int var2, int var3) throws IOException;

    public final byte[] getBytes(int length) throws IOException {
        byte[] dest = new byte[length];
        this.get(dest, 0, length);
        return dest;
    }

    public final byte[] getBytes(int pos, int length) throws IOException {
        byte[] dest = new byte[length];
        this.getBytes(dest, pos, length);
        return dest;
    }

    public final void getBytes(byte[] dest, int pos, int length) throws IOException {
        int origPos = this.m_position;
        this.position(pos);
        this.get(dest, 0, length);
        this.m_position = origPos;
    }

    public final char getChar() throws IOException {
        return (char)this.getShort();
    }

    public final char getChar(int pos) throws IOException {
        return (char)this.getShort(pos);
    }

    public final double getDouble() throws IOException {
        int origPos = this.m_position;
        double result = this.getDouble(this.m_position);
        this.m_position = origPos + 8;
        return result;
    }

    public abstract double getDouble(int var1) throws IOException;

    public final boolean getEquals(String s, String charsetName) throws IOException {
        return s.equals(this.getString(s.length(), charsetName));
    }

    public final boolean getEquals(int pos, String s, String charsetName) throws IOException {
        return s.equals(this.getString(pos, s.length(), charsetName));
    }

    public final float getFloat() throws IOException {
        int origPos = this.m_position;
        float result = this.getFloat(this.m_position);
        this.m_position = origPos + 4;
        return result;
    }

    public abstract float getFloat(int var1) throws IOException;

    public final int getInt() throws IOException {
        int origPos = this.m_position;
        int result = this.getInt(this.m_position);
        this.m_position = origPos + 4;
        return result;
    }

    public abstract int getInt(int var1) throws IOException;

    public final long getLong() throws IOException {
        int origPos = this.m_position;
        long result = this.getLong(this.m_position);
        this.m_position = origPos + 8;
        return result;
    }

    public abstract long getLong(int var1) throws IOException;

    public final short getShort() throws IOException {
        int origPos = this.m_position;
        short result = this.getShort(this.m_position);
        this.m_position = origPos + 2;
        return result;
    }

    public abstract short getShort(int var1) throws IOException;

    public final String getString(int length, String charsetName) throws IOException {
        return new String(this.getBytes(length), charsetName);
    }

    public final String getString(int pos, int length, String charsetName) throws IOException {
        return new String(this.getBytes(pos, length), charsetName);
    }

    public final int getUnsignedByte() throws IOException {
        return this.get() & 0xFF;
    }

    public final int getUnsignedByte(int pos) throws IOException {
        return this.get(pos) & 0xFF;
    }

    public final int getUnsignedShort() throws IOException {
        return this.getShort() & 0xFFFF;
    }

    public final int getUnsignedShort(int pos) throws IOException {
        return this.getShort(pos) & 0xFFFF;
    }

    public final int initialOffset() {
        return this.m_initialOffset;
    }

    public LCByteBuffer initialOffset(int offset) {
        this.m_initialOffset = offset;
        return this;
    }

    public final int limit() {
        return this.m_limit;
    }

    public LCByteBuffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.m_capacity) {
            throw new IllegalArgumentException();
        }
        this.m_limit = newLimit;
        if (this.m_position > this.m_limit) {
            this.m_position = this.m_limit;
        }
        return this;
    }

    public abstract ByteOrder order();

    public abstract LCByteBuffer order(ByteOrder var1);

    public final int position() {
        return this.m_position;
    }

    public final LCByteBuffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.m_limit) {
            throw new IllegalArgumentException();
        }
        this.m_position = newPosition;
        return this;
    }

    public ByteOrder probeOrder(int shortOffset) throws IOException {
        ByteOrder origOrder = this.order();
        this.order(ByteOrder.BIG_ENDIAN);
        int nBig = this.getUnsignedShort(shortOffset);
        this.order(ByteOrder.LITTLE_ENDIAN);
        int nLittle = this.getUnsignedShort(shortOffset);
        if (nLittle > nBig) {
            this.order(ByteOrder.BIG_ENDIAN);
        }
        return origOrder;
    }

    public abstract LCByteBuffer put(int var1, byte var2) throws IOException;

    public final LCByteBuffer put(byte value) throws IOException {
        int origPos = this.m_position;
        this.put(this.m_position, value);
        this.m_position = origPos + 1;
        return this;
    }

    public final LCByteBuffer putDouble(double value) throws IOException {
        int origPos = this.m_position;
        this.putDouble(this.m_position, value);
        this.m_position = origPos + 8;
        return this;
    }

    public abstract LCByteBuffer putDouble(int var1, double var2) throws IOException;

    public final LCByteBuffer putFloat(float value) throws IOException {
        int origPos = this.m_position;
        this.putFloat(this.m_position, value);
        this.m_position = origPos + 4;
        return this;
    }

    public abstract LCByteBuffer putFloat(int var1, float var2) throws IOException;

    public final LCByteBuffer putInt(int value) throws IOException {
        int origPos = this.m_position;
        this.putInt(this.m_position, value);
        this.m_position = origPos + 4;
        return this;
    }

    public abstract LCByteBuffer putInt(int var1, int var2) throws IOException;

    public final LCByteBuffer putLong(long value) throws IOException {
        int origPos = this.m_position;
        this.putLong(this.m_position, value);
        this.m_position = origPos + 8;
        return this;
    }

    public abstract LCByteBuffer putLong(int var1, long var2) throws IOException;

    public final LCByteBuffer putShort(short value) throws IOException {
        int origPos = this.m_position;
        this.putShort(this.m_position, value);
        this.m_position = origPos + 2;
        return this;
    }

    public abstract LCByteBuffer putShort(int var1, short var2) throws IOException;

    public final int remaining() {
        return this.m_limit - this.m_position;
    }

    public LCByteBuffer skipBytes(int count) {
        return this.position(this.m_position + count);
    }

    protected LCByteBuffer(int capacity) {
        this.m_capacity = this.m_limit = capacity;
        this.m_position = 0;
    }
}

