/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateDatabaseListener;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.templates.Locale;
import com.lightcrafts.ui.templates.ManageButton;
import com.lightcrafts.ui.templates.PlusButton;
import com.lightcrafts.ui.templates.TemplateControlListener;
import com.lightcrafts.ui.templates.TemplatePreview;
import com.lightcrafts.ui.templates.TemplatePreviewMouseListener;
import com.lightcrafts.ui.templates.TemplateRootNode;
import com.lightcrafts.ui.templates.TemplateTree;
import com.lightcrafts.ui.toolkit.PaneTitle;
import java.awt.event.MouseWheelEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class TemplateControl
extends JPanel
implements TemplateDatabaseListener {
    private static final String ControlTitle = Locale.LOCALE.get("TemplateControlTitle");
    private Editor editor;
    private JScrollPane scroll;
    private TemplatePreview preview;
    private TemplateTree tree;
    private PlusButton plus;
    private TemplateControlListener listener;

    public TemplateControl(Editor editor, TemplateControlListener listener) {
        this.editor = editor;
        this.initialize();
        TemplateDatabase.addListener(this);
        this.listener = listener;
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setOpaque(true);
        this.setBorder(LightZoneSkin.getPaneBorder());
        this.setEnabled(true);
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public JComponent getScrollPane() {
        return this.scroll;
    }

    public void horizontalMouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() >= 2 && this.scroll.isWheelScrollingEnabled()) {
            JScrollBar bar = this.scroll.getHorizontalScrollBar();
            int dir = e.getWheelRotation() < 0 ? -1 : 1;
            int inc = bar.getUnitIncrement(dir);
            int value = bar.getValue() - e.getWheelRotation() * inc;
            bar.setValue(value);
        }
    }

    public void dispose() {
        TemplateDatabase.removeListener(this);
    }

    @Override
    public void templatesChanged() {
        this.refresh();
    }

    public void refresh() {
        this.removeAll();
        this.initialize();
        this.revalidate();
    }

    private void initialize() {
        try {
            TemplateRootNode root = new TemplateRootNode();
            this.tree = this.editor != null ? new TemplateTree(root, this.editor) : new TemplateTree(root);
        }
        catch (TemplateDatabase.TemplateException e) {
            e.printStackTrace();
        }
        if (this.tree != null) {
            this.scroll = new JScrollPane(this.tree);
        } else {
            String message = Locale.LOCALE.get("TemplateDatabaseErrorMessage");
            JLabel label = new JLabel(message);
            this.scroll = new JScrollPane(label);
        }
        this.scroll.getViewport().setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.scroll.setBorder(null);
        this.plus = new PlusButton(this);
        ManageButton manage = new ManageButton();
        manage.setPreferredSize(this.plus.getPreferredSize());
        this.preview = this.editor != null ? new TemplatePreview(this.editor.getEngine()) : new TemplatePreview();
        TemplatePreviewMouseListener previewListener = new TemplatePreviewMouseListener(this.tree, this.preview);
        this.tree.addMouseListener(previewListener);
        this.tree.addMouseMotionListener(previewListener);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.preview);
        this.add(new TemplatesPaneTitle(this.plus, manage));
        this.add(this.scroll);
    }

    public String getNamespace() {
        TemplateKey key = this.tree.getSelectedTemplateKey();
        return key != null ? key.getNamespace() : null;
    }

    public void setNamespace(String namespace) {
        this.tree.setNamespace(namespace);
    }

    void plusButtonPressed() {
        if (this.listener != null) {
            this.listener.addTemplate();
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        TemplateControl control = new TemplateControl(null, new TemplateControlListener(){

            @Override
            public void addTemplate() {
                System.out.println("add template");
            }
        });
        JFrame frame = new JFrame("TemplateControl Test");
        frame.setContentPane(control);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static class TemplatesPaneTitle
    extends PaneTitle {
        TemplatesPaneTitle(PlusButton plus, ManageButton manage) {
            Box labelBox = this.createLabelBox(ControlTitle);
            labelBox.add(manage);
            labelBox.add(Box.createHorizontalStrut(4));
            labelBox.add(plus);
            labelBox.add(Box.createHorizontalStrut(4));
            this.assembleTitle(labelBox);
        }
    }
}

