/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.scroll;

import com.lightcrafts.ui.scroll.CenteringScrollPane;
import com.lightcrafts.ui.scroll.Panner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class PannerOverlay
extends JLayeredPane {
    private JScrollPane scroll;
    private Panner panner;

    public PannerOverlay(CenteringScrollPane scroll) {
        this.scroll = scroll;
        this.panner = new Panner(scroll);
        this.setLayout(null);
        this.add((Component)scroll, DEFAULT_LAYER);
        this.add((Component)this.panner, PALETTE_LAYER);
        this.panner.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                if (isEnabled) {
                    PannerOverlay.this.add((Component)PannerOverlay.this.panner, JLayeredPane.PALETTE_LAYER);
                } else {
                    PannerOverlay.this.remove(PannerOverlay.this.panner);
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.scroll.getPreferredSize();
        Insets insets = this.getInsets();
        return new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this.scroll.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        Dimension pannerSize = this.panner.getPreferredSize();
        this.panner.setLocation(size.width - pannerSize.width - insets.right - 20, size.height - pannerSize.height - insets.top - 20);
        this.panner.setSize(pannerSize);
    }

    public static void main(String[] args) {
        JTree comp = new JTree();
        comp.setBackground(Color.gray);
        CenteringScrollPane scroll = new CenteringScrollPane(comp);
        PannerOverlay panner = new PannerOverlay(scroll);
        JFrame frame = new JFrame("PannerOverlay");
        frame.setContentPane(panner);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

