/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.Polynomial;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

class Linear
extends Polynomial {
    private double a;
    private double b;

    static Linear createFactored(double z0) {
        return new Linear(-z0, 1.0);
    }

    Linear(double a, double b) {
        super(a, b);
        this.a = a;
        this.b = b;
    }

    @Override
    Polynomial translate(double x) {
        return new Linear(this.a + this.b * x, this.b);
    }

    static Shape createShape(Polynomial x, Polynomial y) {
        if (x.getDegree() != 1 || y.getDegree() != 1) {
            throw new IllegalArgumentException("Expected degree 1");
        }
        double xa = x.getCoeff(0);
        double xb = x.getCoeff(1);
        double ya = y.getCoeff(0);
        double yb = y.getCoeff(1);
        Point2D.Double c1 = new Point2D.Double(xa, ya);
        Point2D.Double c2 = new Point2D.Double(xa + xb, ya + yb);
        return new Line2D.Double(((Point2D)c1).getX(), ((Point2D)c1).getY(), ((Point2D)c2).getX(), ((Point2D)c2).getY());
    }
}

