/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.AbstractCurve;
import com.lightcrafts.ui.region.curves.Cubic;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class CubicBezierCurve
extends AbstractCurve {
    @Override
    void updateShape() {
        if (this.points.size() < 2) {
            this.shape = null;
            this.segments.clear();
            return;
        }
        GeneralPath path = new GeneralPath();
        int[] xPts = new int[this.points.size()];
        int[] yPts = new int[this.points.size()];
        int count = 0;
        for (Point2D p : this.points) {
            xPts[count] = (int)p.getX();
            yPts[count] = (int)p.getY();
            ++count;
        }
        Cubic[] xPoly = this.calcNaturalCubic(xPts);
        Cubic[] yPoly = this.calcNaturalCubic(yPts);
        this.segments.clear();
        for (int n = 0; n < count; ++n) {
            Shape curve = Cubic.createShape(xPoly[n], yPoly[n]);
            this.segments.add(curve);
            path.append(curve, true);
        }
        path.closePath();
        this.shape = path;
    }

    private Cubic[] calcNaturalCubic(int[] x) {
        int k;
        int n = x.length - 1;
        double[] w = new double[n + 1];
        double[] v = new double[n + 1];
        double[] y = new double[n + 1];
        double[] D = new double[n + 1];
        double z = 0.25;
        v[1] = 0.25;
        w[1] = 0.25;
        y[0] = z * 3.0 * (double)(x[1] - x[n]);
        double H = 4.0;
        double F = 3 * (x[0] - x[n - 1]);
        double G = 1.0;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0 / (4.0 - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * ((double)(3 * (x[k + 1] - x[k - 1])) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        Cubic[] C = new Cubic[n + 1];
        for (k = 0; k < n; ++k) {
            C[k] = new Cubic(x[k], D[k], (double)(3 * (x[k + 1] - x[k])) - 2.0 * D[k] - D[k + 1], (double)(2 * (x[k] - x[k + 1])) + D[k] + D[k + 1]);
        }
        C[n] = new Cubic(x[n], D[n], (double)(3 * (x[0] - x[n])) - 2.0 * D[n] - D[0], (double)(2 * (x[n] - x[0])) + D[n] + D[0]);
        return C;
    }
}

