/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.AbstractCurve;
import com.lightcrafts.ui.region.curves.BasisFunction;
import com.lightcrafts.ui.region.curves.CubicBasisFunction;
import com.lightcrafts.ui.region.curves.Polynomial;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CubicBasisSpline
extends AbstractCurve {
    static ArrayList Bases = new ArrayList();

    static void ensureBases(int count) {
        while (Bases.size() < count) {
            int i = Bases.size();
            CubicBasisFunction basis = new CubicBasisFunction(i);
            Bases.add(basis);
        }
    }

    @Override
    void updateShape() {
        if (this.points.size() < 2) {
            this.shape = null;
            this.segments.clear();
            return;
        }
        ArrayList extraPoints = new ArrayList(this.points);
        extraPoints.add(0, this.points.get(this.points.size() - 2));
        extraPoints.add(1, this.points.get(this.points.size() - 1));
        extraPoints.add(this.points.get(0));
        extraPoints.add(this.points.get(1));
        Object first = extraPoints.get(0);
        extraPoints.remove(0);
        extraPoints.add(first);
        GeneralPath path = new GeneralPath();
        int m = extraPoints.size();
        CubicBasisSpline.ensureBases(m);
        this.segments.clear();
        for (int i = 3; i < m - 1; ++i) {
            Polynomial xPoly = new Polynomial(0.0);
            Polynomial yPoly = new Polynomial(0.0);
            for (int j = 0; j < m; ++j) {
                Point2D p = (Point2D)extraPoints.get(j);
                BasisFunction basis = (BasisFunction)Bases.get(j);
                double px = p.getX();
                double py = p.getY();
                Polynomial xSeg = basis.getSegment(i).multiply(px);
                Polynomial ySeg = basis.getSegment(i).multiply(py);
                xPoly = xPoly.add(xSeg);
                yPoly = yPoly.add(ySeg);
            }
            xPoly = xPoly.translate(i);
            yPoly = yPoly.translate(i);
            Shape curve = Polynomial.createShape(xPoly, yPoly);
            this.segments.add(curve);
            path.append(curve, true);
        }
        path.closePath();
        this.shape = path;
    }
}

