/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class ClonePoint
implements Cloneable {
    private static final int NominalRadius = 8;
    private Stroke foregroundStroke = new BasicStroke(1.0f);
    private Stroke backgroundStroke = new BasicStroke(3.0f);
    private float radius = 8.0f;
    private Point2D point;
    private GeneralPath shape;

    ClonePoint() {
        this(new Point2D.Double());
    }

    ClonePoint(Point2D p) {
        this.setPoint(p);
    }

    void setPoint(Point2D p) {
        this.point = (Point2D)p.clone();
        this.updateShape();
    }

    Point2D getPoint() {
        return (Point2D)this.point.clone();
    }

    void translate(double dx, double dy) {
        this.point.setLocation(this.point.getX() + dx, this.point.getY() + dy);
        this.updateShape();
    }

    void paint(Graphics2D g) {
        AffineTransform xform = g.getTransform();
        float scale = (float)Math.sqrt(Math.abs(xform.getDeterminant()));
        float r = 8.0f / (scale = Math.min(scale, 1.0f));
        if (r != this.radius) {
            this.radius = r;
            this.updateShape();
        }
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(Color.black);
        g.setStroke(this.backgroundStroke);
        g.draw(this.shape);
        g.setColor(Color.white);
        g.setStroke(this.foregroundStroke);
        g.draw(this.shape);
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    boolean isAt(Point2D p) {
        return this.shape.getBounds2D().contains(p);
    }

    Rectangle2D getPaintBounds() {
        Shape stroked = this.backgroundStroke.createStrokedShape(this.shape);
        return stroked.getBounds2D();
    }

    public Object clone() {
        return new ClonePoint(this.point);
    }

    void save(XmlNode node) {
        node.setAttribute("x", Double.toString(this.point.getX()));
        node.setAttribute("y", Double.toString(this.point.getY()));
    }

    void restore(XmlNode node) throws XMLException {
        double x = Double.parseDouble(node.getAttribute("x"));
        double y = Double.parseDouble(node.getAttribute("y"));
        Point2D.Double p = new Point2D.Double(x, y);
        this.setPoint(p);
    }

    private void updateShape() {
        this.foregroundStroke = new BasicStroke(this.radius / 8.0f);
        this.backgroundStroke = new BasicStroke(3.0f * this.radius / 8.0f);
        float x = (float)this.point.getX();
        float y = (float)this.point.getY();
        this.shape = new GeneralPath();
        this.shape.moveTo(x, y - this.radius);
        this.shape.lineTo(x, y - this.radius / 2.0f);
        this.shape.moveTo(x, y + this.radius / 2.0f);
        this.shape.lineTo(x, y + this.radius);
        this.shape.moveTo(x - this.radius, y);
        this.shape.lineTo(x - this.radius / 2.0f, y);
        this.shape.moveTo(x + this.radius / 2.0f, y);
        this.shape.lineTo(x + this.radius, y);
    }
}

