/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.print.PreviewComponent;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.print.PrintLayoutModelListener;
import java.awt.BorderLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class PreviewPanel
extends JPanel
implements PrintLayoutModelListener {
    private PreviewComponent component;

    PreviewPanel(BufferedImage image, PrintLayoutModel model) {
        PageFormat page = model.getPageFormat();
        this.component = new PreviewComponent(image, page);
        this.layoutChanged(model);
        this.setLayout(new BorderLayout());
        this.add(this.component);
        TitledBorder border = BorderFactory.createTitledBorder("Preview");
        this.setBorder(border);
        model.addListener(this);
    }

    @Override
    public void layoutChanged(PrintLayoutModel model) {
        PageFormat page = model.getPageFormat();
        this.component.setPageFormat(page);
        Rectangle2D rect = model.getImageRect();
        this.component.setImageRect(rect);
    }
}

