/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.zone.Locale;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ZoneScaleButtons
extends JPanel
implements ItemListener {
    private static final String RgbLabel = Locale.LOCALE.get("RgbLabel");
    private static final String RgbToolTip = Locale.LOCALE.get("RgbToolTip");
    private static final String LuminosityLabel = Locale.LOCALE.get("LuminosityLabel");
    private static final String LuminosityToolTip = Locale.LOCALE.get("LuminosityToolTip");
    private ZoneOperation op;
    private JRadioButton rgbButton;
    private JRadioButton luminosityButton;
    private OpControl.OpControlUndoSupport undoSupport;
    private static final String ScaleTag = "scale";

    ZoneScaleButtons(ZoneOperation op, OpControl.OpControlUndoSupport undoSupport) {
        this.op = op;
        this.undoSupport = undoSupport;
        this.rgbButton = new JRadioButton(RgbLabel);
        this.rgbButton.setToolTipText(RgbToolTip);
        this.rgbButton.addItemListener(this);
        this.rgbButton.setFocusable(false);
        this.luminosityButton = new JRadioButton(LuminosityLabel);
        this.luminosityButton.setToolTipText(LuminosityToolTip);
        this.luminosityButton.addItemListener(this);
        this.luminosityButton.setFocusable(false);
        this.luminosityButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.luminosityButton);
        group.add(this.rgbButton);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.luminosityButton);
        this.add(this.rgbButton);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.setScale();
            if (!this.undoSupport.isRestoring()) {
                this.undoSupport.postEdit(Locale.LOCALE.get("ZoneTypeEditName"));
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.rgbButton != null) {
            this.rgbButton.setBackground(color);
            this.luminosityButton.setBackground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.rgbButton != null) {
            this.rgbButton.setFont(font);
            this.luminosityButton.setFont(font);
        }
    }

    void operationChanged(ZoneOperation op) {
        this.op = op;
        this.setScale();
    }

    private void setScale() {
        if (this.rgbButton.isSelected()) {
            this.op.setScale(0);
        } else {
            this.op.setScale(1);
        }
    }

    void save(XmlNode node) {
        int value = this.rgbButton.isSelected() ? 0 : 1;
        node.setAttribute(ScaleTag, Integer.toString(value));
    }

    void restore(XmlNode node) throws XMLException {
        if (node.hasAttribute(ScaleTag)) {
            int value = Integer.parseInt(node.getAttribute(ScaleTag));
            if (value == 0) {
                this.rgbButton.setSelected(true);
            } else {
                this.luminosityButton.setSelected(true);
            }
        }
    }
}

