/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.RedEyeOperation;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.clone.CloneControl;
import com.lightcrafts.ui.operation.clone.SpotControl;
import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

class RegionSwitch
extends JToggleButton
implements ItemListener {
    private static final Icon NormalIcon;
    private static final Icon InvertedIcon;
    private OpControl control;
    private OpControl.OpControlUndoSupport undoSupport;
    private static final String InvertedTag = "regionsInverted";

    RegionSwitch(OpControl control) {
        this.control = control;
        this.setIcon(NormalIcon);
        this.setSelectedIcon(InvertedIcon);
        this.undoSupport = control.undoSupport;
        this.setToolTipText(Locale.LOCALE.get("InvertMaskToolTip"));
        ImageOnlyButton.setStyle(this);
        this.addItemListener(this);
        if (control instanceof CloneControl || control instanceof SpotControl || control.getOperation() instanceof RedEyeOperation) {
            this.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        boolean selected = event.getStateChange() == 1;
        this.control.setRegionInverted(selected);
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(Locale.LOCALE.get("InvertMaskEditName"));
        }
    }

    boolean isRegionsInverted() {
        return this.isSelected();
    }

    void save(XmlNode node) {
        node.setAttribute(InvertedTag, Boolean.toString(this.isRegionsInverted()));
    }

    void restore(XmlNode node) throws XMLException {
        if (node.hasAttribute(InvertedTag)) {
            String value = node.getAttribute(InvertedTag);
            boolean isInverted = Boolean.valueOf(value);
            this.setSelected(isInverted);
        }
    }

    static {
        try {
            NormalIcon = new ImageIcon(ImageIO.read(RegionSwitch.class.getResource("resources/normal_region.png")));
            InvertedIcon = new ImageIcon(ImageIO.read(RegionSwitch.class.getResource("resources/inverted_region.png")));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize RegionSwitch", e);
        }
    }
}

