/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.ui.metadata2.SimpleMetadataEntry;

class RatingMetadataEntry
extends SimpleMetadataEntry {
    RatingMetadataEntry() {
        super(CoreDirectory.class, 518);
    }

    @Override
    public RatingObject getValue(ImageMetadata meta) {
        ImageMetadataDirectory dir = meta.getDirectoryFor(this.clazz);
        if (dir != null) {
            ImageMetaValue value = dir.getValue(this.tagID);
            return new RatingObject(value);
        }
        return new RatingObject(null);
    }

    @Override
    public boolean isEditable(ImageInfo info) {
        return info.canWriteMetadata();
    }

    @Override
    public boolean isValidValue(ImageMetadata meta, String value) {
        if (value.replaceAll("\u2605", "").length() == 0) {
            return true;
        }
        try {
            int i = Integer.parseInt(value);
            return i >= 0 && i <= 5;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setValue(ImageMetadata meta, String value) {
        if (value.replaceAll("\u2605", "").length() == 0) {
            int i = value.length();
            if (i > 0) {
                meta.setRating(i);
            } else {
                meta.clearRating();
            }
            return;
        }
        try {
            Integer i = Integer.parseInt(value);
            if (i > 0 && i <= 5) {
                meta.setRating(i);
            } else if (i > 5) {
                meta.setRating(5);
            } else {
                meta.clearRating();
            }
        }
        catch (NumberFormatException e) {
            meta.clearRating();
        }
    }

    class RatingObject {
        ImageMetaValue value;

        RatingObject(ImageMetaValue value) {
            this.value = value;
        }

        public String toString() {
            if (this.value != null && this.value.getIntValue() > 0) {
                String text = this.value.toString();
                return text;
            }
            return "";
        }
    }
}

