/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.export.IntegerExportOption;
import com.lightcrafts.image.export.ResizeHeightOption;
import com.lightcrafts.image.export.ResizeWidthOption;
import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class ExportSizeFields {
    private JTextField xText;
    private JTextField yText;
    private double ratio;
    private boolean isXUpdating;
    private boolean isYUpdating;
    private static final FocusListener FocusSelector = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            JTextField text = (JTextField)event.getSource();
            text.selectAll();
        }
    };
    private static final ActionListener UpAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            final JTextField source = (JTextField)event.getSource();
            InputVerifier verifier = source.getInputVerifier();
            if (!verifier.verify(source)) {
                return;
            }
            final int number = Integer.parseInt(source.getText());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    source.setText(Integer.toString(number + 1));
                }
            });
        }
    };
    private static final ActionListener DownAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            final JTextField source = (JTextField)event.getSource();
            InputVerifier verifier = source.getInputVerifier();
            if (!verifier.verify(source)) {
                return;
            }
            final int number = Integer.parseInt(source.getText());
            if (number > 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        source.setText(Integer.toString(number - 1));
                    }
                });
            }
        }
    };
    private static final InputVerifier Verifier = new InputVerifier(){

        @Override
        public boolean verify(JComponent input) {
            double x;
            String text = ((JTextField)input).getText();
            try {
                x = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return x > 0.0;
        }
    };

    ExportSizeFields(ImageExportOptions options) {
        ImageFileExportOptions fileOptions = (ImageFileExportOptions)options;
        ResizeWidthOption widthOption = fileOptions.resizeWidth;
        ResizeHeightOption heightOption = fileOptions.resizeHeight;
        int x = widthOption.getValue();
        int y = heightOption.getValue();
        this.xText = ExportSizeFields.createTextField(x);
        this.yText = ExportSizeFields.createTextField(y);
        int width = fileOptions.originalWidth.getValue();
        int height = fileOptions.originalHeight.getValue();
        this.ratio = (double)width / (double)height;
        new ExportUpdater(widthOption, this.xText);
        new ExportUpdater(heightOption, this.yText);
    }

    JTextField getXText() {
        return this.xText;
    }

    JTextField getYText() {
        return this.yText;
    }

    private static JTextField createTextField(int value) {
        JTextField text = new JTextField(4);
        text.setText(Integer.toString(value));
        text.setInputVerifier(Verifier);
        text.addFocusListener(FocusSelector);
        text.setHorizontalAlignment(4);
        text.registerKeyboardAction(UpAction, "Increment", KeyStroke.getKeyStroke(38, 0), 0);
        text.registerKeyboardAction(DownAction, "Decrement", KeyStroke.getKeyStroke(40, 0), 0);
        return text;
    }

    private void xUpdated() {
        if (!this.isYUpdating) {
            this.isXUpdating = true;
            int x = Integer.parseInt(this.xText.getText());
            int y = (int)Math.round((double)x / this.ratio);
            this.yText.setText(Integer.toString(y));
            this.isXUpdating = false;
        }
    }

    private void yUpdated() {
        if (!this.isXUpdating) {
            this.isYUpdating = true;
            int y = Integer.parseInt(this.yText.getText());
            int x = (int)Math.round((double)y * this.ratio);
            this.xText.setText(Integer.toString(x));
            this.isYUpdating = false;
        }
    }

    private final class ExportUpdater
    implements DocumentListener {
        private IntegerExportOption option;
        private JTextField text;

        ExportUpdater(IntegerExportOption option, JTextField text) {
            this.option = option;
            this.text = text;
            Document doc = text.getDocument();
            doc.addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleDocumentChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleDocumentChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleDocumentChange();
        }

        private void handleDocumentChange() {
            InputVerifier verifier = this.text.getInputVerifier();
            boolean verified = verifier.verify(this.text);
            if (!verified) {
                this.text.setForeground(Color.red);
            } else {
                this.text.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
                int value = Integer.parseInt(this.text.getText());
                this.option.setValue(value);
                if (this.text == ExportSizeFields.this.xText) {
                    ExportSizeFields.this.xUpdated();
                }
                if (this.text == ExportSizeFields.this.yText) {
                    ExportSizeFields.this.yUpdated();
                }
            }
        }
    }
}

