/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.CropBounds;
import com.lightcrafts.model.Operation;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.crop.CropListener;
import com.lightcrafts.ui.crop.CropMode;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.editor.ModeButtons;
import com.lightcrafts.ui.editor.ProofSelectableControl;
import com.lightcrafts.ui.editor.XFormListener;
import com.lightcrafts.ui.mode.AbstractMode;
import com.lightcrafts.ui.mode.Mode;
import com.lightcrafts.ui.mode.ModeOverlay;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpControlModeListener;
import com.lightcrafts.ui.operation.OpStackListener;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.region.RegionOverlay;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ModeManager
implements OpStackListener,
OpControlModeListener,
XFormListener {
    private static int PanKeyCode = ModeManager.isMac() ? 157 : 17;
    private KeyEventPostProcessor panModeKeyProcessor = new KeyEventPostProcessor(){
        private boolean isPanMode;

        @Override
        public boolean postProcessKeyEvent(KeyEvent e) {
            boolean wasPanMode;
            boolean bl = wasPanMode = ModeManager.this.overlay.peekMode() == ModeManager.this.transientPanMode;
            if (e.getKeyCode() == PanKeyCode) {
                if (e.getID() == 401) {
                    this.isPanMode = true;
                }
                if (e.getID() == 402) {
                    boolean isReallyPressed;
                    this.isPanMode = Platform.getType() == Platform.MacOSX ? false : (isReallyPressed = Platform.getPlatform().isKeyPressed(PanKeyCode));
                }
            }
            if (this.isPanMode && !wasPanMode) {
                ModeManager.this.overlay.pushMode(ModeManager.this.transientPanMode);
            }
            if (wasPanMode && !this.isPanMode) {
                ModeManager.this.overlay.popMode();
            }
            return false;
        }
    };
    private Document doc;
    private ModeOverlay overlay;
    private AffineTransform xform;
    private Mode regionMode;
    private CropMode cropMode;
    private AbstractMode transientPanMode;
    private AbstractMode permanentPanMode;
    private CropMode rotateMode;
    private JComponent regionExtras;
    private ModeButtons modeButtons;
    private OpControl control;
    private Mode controlMode;
    private Rectangle underlayBounds;
    EditorMode m_editorMode;

    ModeManager(Mode regionMode, CropMode cropMode, AbstractMode transientPanMode, AbstractMode permanentPanMode, CropMode rotateMode, ModeOverlay overlay, Component underlay, JComponent regionExtras, Document doc) {
        this.overlay = overlay;
        this.regionExtras = regionExtras;
        this.doc = doc;
        this.xform = new AffineTransform();
        this.regionMode = regionMode;
        this.cropMode = cropMode;
        this.transientPanMode = transientPanMode;
        this.permanentPanMode = permanentPanMode;
        this.rotateMode = rotateMode;
        overlay.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                ModeManager.this.setTransform(ModeManager.this.xform);
            }
        });
        underlay.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Rectangle bounds = event.getComponent().getBounds();
                ModeManager.this.setUnderlayBounds(bounds);
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                Rectangle bounds = event.getComponent().getBounds();
                ModeManager.this.setUnderlayBounds(bounds);
            }
        });
        cropMode.addCropListener(new CropListener(){

            @Override
            public void cropCommitted(CropBounds bounds) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ModeManager.this.modeButtons != null && ModeManager.this.modeButtons.isCropSelected()) {
                            ModeManager.this.setEditorMode(EditorMode.ARROW);
                        }
                    }
                });
            }

            @Override
            public void unCrop() {
            }
        });
        rotateMode.addCropListener(new CropListener(){

            @Override
            public void cropCommitted(CropBounds bounds) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ModeManager.this.modeButtons != null && ModeManager.this.modeButtons.isRotateSelected()) {
                            ModeManager.this.setEditorMode(EditorMode.ARROW);
                        }
                    }
                });
            }

            @Override
            public void unCrop() {
            }
        });
        this.registerPanModeListener();
        this.setMode(this.permanentPanMode);
    }

    public EditorMode getMode() {
        return this.m_editorMode;
    }

    void setModeButtons(ModeButtons buttons) {
        this.modeButtons = buttons;
    }

    @Override
    public void opAdded(OpControl control) {
    }

    @Override
    public void opChanged(OpControl control) {
        boolean isRaw;
        if (this.isControlModeActive()) {
            this.exitMode(null);
        }
        if (this.control != null) {
            this.control.removeModeListener(this);
        } else {
            this.setEditorMode(EditorMode.ARROW);
        }
        this.control = control;
        if (control != null && !control.isLocked()) {
            control.addModeListener(this);
        }
        boolean isLocked = control != null && control.isLocked();
        boolean bl = isRaw = control != null && control.isRawCorrection();
        if (isLocked || isRaw) {
            this.modeButtons.setRegionsEnabled(false);
        } else {
            this.modeButtons.setRegionsEnabled(true);
        }
        if (control != null) {
            Operation op = control.getOperation();
            EditorMode prefMode = op.getPreferredMode();
            if (isLocked || isRaw || prefMode != EditorMode.ARROW || this.m_editorMode == EditorMode.ARROW) {
                this.setEditorMode(prefMode);
            }
        }
    }

    @Override
    public void opChanged(SelectableControl control) {
        if (this.control != null) {
            this.control.removeModeListener(this);
            this.control = null;
        }
        if (control instanceof ProofSelectableControl) {
            this.setMode(null);
        }
        if (control == null) {
            this.setMode(null);
        }
    }

    @Override
    public void opLockChanged(OpControl control) {
        if (this.control == control) {
            this.opChanged(control);
        }
    }

    @Override
    public void opRemoved(OpControl control) {
        Operation op;
        if (this.overlay.peekMode() == this.regionMode && this.control != null && (op = this.control.getOperation()).getPreferredMode() != EditorMode.REGION) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModeManager.this.setEditorMode(EditorMode.ARROW);
                }
            });
        }
    }

    public void setEditorMode(EditorMode mode) {
        if (mode == this.m_editorMode) {
            return;
        }
        if (this.modeButtons != null) {
            switch (mode) {
                case ARROW: {
                    this.modeButtons.clickNoMode();
                    break;
                }
                case CROP: {
                    this.modeButtons.clickCropButton();
                    break;
                }
                case REGION: {
                    this.modeButtons.clickRegionButton();
                    break;
                }
                case ROTATE: {
                    this.modeButtons.clickRotateButton();
                }
            }
        }
        this.m_editorMode = mode;
    }

    @Override
    public void enterMode(Mode mode) {
        mode.enter();
        assert (!this.isControlModeActive());
        this.controlMode = mode;
        this.controlMode.setTransform(this.getOverlayTransform());
        this.overlay.pushMode(this.controlMode);
    }

    @Override
    public void exitMode(Mode mode) {
        assert (this.isControlModeActive());
        if (mode != null) {
            mode.exit();
        }
        this.overlay.popMode();
        this.controlMode = null;
    }

    @Override
    public void xFormChanged(AffineTransform xform) {
        JScrollPane scroll = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.overlay);
        if (scroll != null) {
            this.overlay.invalidate();
            scroll.validate();
        }
        this.setTransform(xform);
    }

    private boolean isControlModeActive() {
        return this.controlMode != null && this.overlay.peekMode().equals(this.controlMode);
    }

    private boolean isTransientPanModeActive() {
        return this.overlay.peekMode().equals(this.transientPanMode);
    }

    private void setTransform(AffineTransform xform) {
        this.xform = xform;
        AffineTransform overlayTransform = this.getOverlayTransform();
        this.regionMode.setTransform(overlayTransform);
        this.cropMode.setTransform(overlayTransform);
        this.transientPanMode.setTransform(overlayTransform);
        this.rotateMode.setTransform(overlayTransform);
        if (this.controlMode != null) {
            this.controlMode.setTransform(overlayTransform);
        }
    }

    AffineTransform getOverlayTransform() {
        AffineTransform overlayXform = this.overlay.getTransform();
        AffineTransform totalXform = (AffineTransform)this.xform.clone();
        totalXform.preConcatenate(overlayXform);
        return totalXform;
    }

    private void setUnderlayBounds(Rectangle bounds) {
        if (bounds.equals(this.underlayBounds)) {
            return;
        }
        this.underlayBounds = bounds;
        this.regionMode.setUnderlayBounds(bounds);
        this.cropMode.setUnderlayBounds(bounds);
        this.transientPanMode.setUnderlayBounds(bounds);
        this.rotateMode.setUnderlayBounds(bounds);
        if (this.controlMode != null) {
            this.controlMode.setUnderlayBounds(bounds);
        }
        CropBounds crop = this.cropMode.getCrop();
        CropBounds initCrop = this.getInitialCropBounds();
        if (crop == null) {
            this.cropMode.setCropWithConstraints(initCrop);
        }
        this.cropMode.setResetCropBounds(initCrop);
    }

    JComponent setNoMode() {
        boolean isFitMode;
        boolean wasCrop = this.overlay.peekMode() == this.cropMode || this.overlay.peekMode() == this.rotateMode;
        this.setMode(null);
        this.m_editorMode = EditorMode.ARROW;
        if (wasCrop && !(isFitMode = this.doc.popFitMode())) {
            this.doc.zoomToFit();
        }
        return null;
    }

    JComponent setCropMode() {
        this.doc.markDirty();
        this.setMode(this.cropMode);
        this.m_editorMode = EditorMode.CROP;
        this.doc.pushFitMode();
        this.doc.zoomToFit();
        return this.cropMode.getControl();
    }

    JComponent setRotateMode() {
        this.doc.markDirty();
        this.setMode(this.rotateMode);
        this.m_editorMode = EditorMode.ROTATE;
        this.doc.pushFitMode();
        this.doc.zoomToFit();
        CropBounds crop = this.cropMode.getCrop();
        this.rotateMode.setCrop(crop);
        this.rotateMode.setResetCropBounds(crop);
        return this.rotateMode.getControl().getResetButton();
    }

    JComponent setRegionMode() {
        boolean isFitMode;
        boolean wasCrop = this.overlay.peekMode() == this.cropMode || this.overlay.peekMode() == this.rotateMode;
        this.setMode(this.regionMode);
        this.m_editorMode = EditorMode.REGION;
        if (wasCrop && !(isFitMode = this.doc.popFitMode())) {
            this.doc.zoomToFit();
        }
        return this.regionExtras;
    }

    private void setMode(Mode newMode) {
        CropMode crop;
        while (this.isControlModeActive() || this.isTransientPanModeActive()) {
            this.overlay.popMode();
            this.controlMode = null;
        }
        Mode oldMode = this.overlay.peekMode();
        if (oldMode == newMode) {
            return;
        }
        if (oldMode == this.regionMode || oldMode == this.cropMode || oldMode == this.rotateMode) {
            if (oldMode == this.regionMode && this.regionMode instanceof RegionOverlay) {
                ((RegionOverlay)this.regionMode).finishEditingCurve();
            }
            this.overlay.popMode();
            if (oldMode == this.cropMode || oldMode == this.rotateMode) {
                crop = (CropMode)oldMode;
                crop.doCrop();
            }
            oldMode.exit();
        }
        if (newMode != null) {
            this.overlay.pushMode(newMode);
            newMode.enter();
        }
        if (newMode == this.cropMode || newMode == this.rotateMode) {
            crop = (CropMode)newMode;
            crop.resetCrop();
        }
        if (oldMode == this.cropMode) {
            this.rotateMode.setCrop(this.cropMode.getCrop());
        }
        if (oldMode == this.rotateMode) {
            this.cropMode.setCrop(this.rotateMode.getCrop());
        }
    }

    private CropBounds getInitialCropBounds() {
        double x = this.underlayBounds.getX();
        double y = this.underlayBounds.getY();
        double width = this.underlayBounds.getWidth();
        double height = this.underlayBounds.getHeight();
        Rectangle2D.Double inset = new Rectangle2D.Double(x, y, width, height);
        CropBounds crop = new CropBounds(inset);
        try {
            AffineTransform inverse = this.getOverlayTransform().createInverse();
            crop = CropBounds.transform(inverse, crop);
            return crop;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    private void registerPanModeListener() {
        KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focus.addKeyEventPostProcessor(this.panModeKeyProcessor);
    }

    void dispose() {
        KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focus.removeKeyEventPostProcessor(this.panModeKeyProcessor);
    }

    private static boolean isMac() {
        return Platform.getType() == Platform.MacOSX;
    }
}

