/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JFrame;

final class EyeButton
extends CoolButton
implements MouseListener {
    private static final Icon Icon = IconFactory.createIcon(EyeButton.class, "eye.png");
    private static final String OriginalTooltip = Locale.LOCALE.get("EyeToolTip");
    private Engine engine;

    EyeButton(Engine engine) {
        this.engine = engine;
        this.setIcon(Icon);
        this.setToolTipText(OriginalTooltip);
        this.addMouseListener(this);
    }

    EyeButton() {
        this.setIcon(Icon);
        this.setToolTipText(OriginalTooltip);
        this.setEnabled(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.engine.setActive(false);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.engine.setActive(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        EyeButton disabled = new EyeButton();
        disabled.setEnabled(false);
        EyeButton enabled = new EyeButton();
        enabled.setEnabled(true);
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(enabled);
        frame.getContentPane().add(disabled);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

