/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Locale;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Scrollable;

class DisabledImageComponent
extends JComponent
implements Scrollable {
    private RenderedImage image;
    private BufferedImage button;
    private static AffineTransform identity = new AffineTransform();

    DisabledImageComponent(RenderedImage image) {
        this.setImage(image);
        this.setCursor(new Cursor(12));
    }

    void setImage(RenderedImage image) {
        this.image = image;
        this.initButton();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(LightZoneSkin.Colors.EditorBackground);
        Shape clip = g.getClip();
        g.fill(clip);
        if (this.image != null) {
            AffineTransform xform = this.getTransform();
            RenderedImage xformedImage = this.image;
            if (!xform.isIdentity()) {
                RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                ParameterBlock params = new ParameterBlock();
                params.addSource(this.image);
                params.add(xform);
                params.add(Interpolation.getInstance((int)1));
                xformedImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)extenderHints);
            }
            g.drawRenderedImage(xformedImage, identity);
            AffineTransform buttonXform = this.getButtonTransform(xform);
            g.drawRenderedImage(this.button, buttonXform);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return new Dimension();
    }

    private AffineTransform getTransform() {
        double sTall;
        Dimension bound = this.getSize();
        double hSpace = bound.width;
        double vSpace = bound.height;
        double sWide = hSpace / (double)this.image.getWidth();
        double s = Math.min(sWide, sTall = vSpace / (double)this.image.getHeight());
        if (s < 1.0) {
            AffineTransform xform = AffineTransform.getScaleInstance(s, s);
            if (sWide < sTall) {
                double gap = Math.floor((vSpace - (double)this.image.getHeight() * s) / 2.0);
                AffineTransform trans = AffineTransform.getTranslateInstance(0.0, gap);
                xform.preConcatenate(trans);
            } else {
                double gap = Math.floor((hSpace - (double)this.image.getWidth() * s) / 2.0);
                AffineTransform trans = AffineTransform.getTranslateInstance(gap, 0.0);
                xform.preConcatenate(trans);
            }
            return xform;
        }
        double hgap = Math.floor((hSpace - (double)this.image.getWidth()) / 2.0);
        double vgap = Math.floor((vSpace - (double)this.image.getHeight()) / 2.0);
        AffineTransform trans = AffineTransform.getTranslateInstance(hgap, vgap);
        return trans;
    }

    private AffineTransform getButtonTransform(AffineTransform imageXform) {
        Point2D imageUpperLeft = new Point2D.Double(0.0, 0.0);
        imageUpperLeft = imageXform.transform(imageUpperLeft, null);
        Point2D imageLowerRight = new Point2D.Double(this.image.getWidth(), this.image.getHeight());
        imageLowerRight = imageXform.transform(imageLowerRight, null);
        double imageW = imageLowerRight.getX() - imageUpperLeft.getX();
        double imageH = imageLowerRight.getY() - imageUpperLeft.getY();
        double buttonW = this.button.getWidth();
        double buttonH = this.button.getHeight();
        if (imageW < 4.0 * buttonW || imageH < 4.0 * buttonH) {
            Point2D.Double center = new Point2D.Double((imageUpperLeft.getX() + imageLowerRight.getX()) / 2.0, (imageUpperLeft.getY() + imageLowerRight.getY()) / 2.0);
            Point2D.Double buttonLoc = new Point2D.Double(((Point2D)center).getX() - buttonW / 2.0, ((Point2D)center).getY() - buttonH / 2.0);
            return AffineTransform.getTranslateInstance(((Point2D)buttonLoc).getX(), ((Point2D)buttonLoc).getY());
        }
        Point2D.Double buttonLoc = new Point2D.Double(imageLowerRight.getX() - (double)(2 * this.button.getWidth()), imageLowerRight.getY() - (double)(2 * this.button.getHeight()));
        return AffineTransform.getTranslateInstance(((Point2D)buttonLoc).getX(), ((Point2D)buttonLoc).getY());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    private void initButton() {
        JLabel comp = new JLabel(Locale.LOCALE.get("ClickToEditMessage"));
        comp.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        Dimension size = comp.getPreferredSize();
        comp.setSize(size);
        this.button = new BufferedImage(size.width + 1, size.height + 1, 2);
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(0.0, 0.0, size.width, size.height, 8.0, 8.0);
        Graphics2D g = (Graphics2D)this.button.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(128, 128, 128, 128));
        g.fill(roundRect);
        comp.paint(g);
        g.setColor(Color.white);
        g.draw(roundRect);
        g.dispose();
    }
}

