/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.ui.crop.AspectConstraint;
import com.lightcrafts.ui.crop.ConstraintModel;
import com.lightcrafts.ui.crop.Locale;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

class ConstraintMenu
extends CoolButton {
    private static Icon Icon = IconFactory.createInvertedIcon(ConstraintMenu.class, "menu.png");
    private static final AspectConstraint OneOneConstraint = new AspectConstraint(1, 1);
    private static final AspectConstraint ThreeFiveConstraint = new AspectConstraint(3, 5);
    private static final AspectConstraint FourSixConstraint = new AspectConstraint(4, 6);
    private static final AspectConstraint FiveSevenConstraint = new AspectConstraint(5, 7);
    private static final AspectConstraint EightTenConstraint = new AspectConstraint(8, 10);
    private static final AspectConstraint ElevenFourteenConstraint = new AspectConstraint(11, 14);
    private JPopupMenu menu;

    ConstraintMenu(ConstraintModel constraints) {
        this.setIcon(Icon);
        this.setFocusable(false);
        this.setToolTipText(Locale.LOCALE.get("AspectRatioToolTip"));
        this.menu = new JPopupMenu();
        this.menu.add(constraints.createMenuAction(OneOneConstraint));
        this.menu.addSeparator();
        this.menu.add(constraints.createMenuAction(ThreeFiveConstraint));
        this.menu.add(constraints.createMenuAction(FourSixConstraint));
        this.menu.add(constraints.createMenuAction(FiveSevenConstraint));
        this.menu.add(constraints.createMenuAction(EightTenConstraint));
        this.menu.add(constraints.createMenuAction(ElevenFourteenConstraint));
        this.menu.addSeparator();
        this.menu.add(constraints.createMenuAction(ThreeFiveConstraint.getInverse()));
        this.menu.add(constraints.createMenuAction(FourSixConstraint.getInverse()));
        this.menu.add(constraints.createMenuAction(FiveSevenConstraint.getInverse()));
        this.menu.add(constraints.createMenuAction(EightTenConstraint.getInverse()));
        this.menu.add(constraints.createMenuAction(ElevenFourteenConstraint.getInverse()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle bounds = ConstraintMenu.this.getBounds();
                ConstraintMenu.this.menu.show(ConstraintMenu.this, 0, bounds.height);
            }
        });
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.menu != null) {
            MenuElement[] items;
            this.menu.setFont(font);
            for (MenuElement item : items = this.menu.getSubElements()) {
                item.getComponent().setFont(font);
            }
        }
    }
}

