/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.RotateActions;
import com.lightcrafts.ui.browser.view.StarSlider;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

class ImageDatumControl {
    private static BufferedImage RotateLeftImage;
    private static BufferedImage RotateRightImage;
    private static BufferedImage RotateLeftHighlightImage;
    private static BufferedImage RotateRightHighlightImage;
    private AbstractImageBrowser browser;
    private StarSlider stars;
    private int index;
    private boolean isEnabled;
    private boolean hoverLeft;
    private boolean hoverRight;

    ImageDatumControl(AbstractImageBrowser browser) {
        this.browser = browser;
        this.stars = new StarSlider(browser);
        this.index = -1;
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    void paint(Graphics2D g) {
        Rectangle rect = this.getRect();
        int x = rect.x;
        int y = rect.y + rect.height - RotateLeftImage.getHeight();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        BufferedImage image = this.hoverLeft ? RotateLeftHighlightImage : RotateLeftImage;
        g.drawRenderedImage(image, xform);
        x = rect.x + rect.width - RotateRightImage.getWidth();
        y = rect.y + rect.height - RotateRightImage.getHeight();
        xform = AffineTransform.getTranslateInstance(x, y);
        image = this.hoverRight ? RotateRightHighlightImage : RotateRightImage;
        g.drawRenderedImage(image, xform);
    }

    Rectangle getRect() {
        if (this.index >= 0) {
            Rectangle rect = this.browser.getBounds(this.index);
            return rect;
        }
        return null;
    }

    private Rectangle getRotateLeftRect() {
        Rectangle rect = this.getRect();
        if (rect != null) {
            int x = rect.x;
            int y = rect.y + rect.height - RotateLeftImage.getHeight();
            int w = RotateLeftImage.getWidth();
            int h = RotateLeftImage.getHeight();
            return new Rectangle(x, y, w, h);
        }
        return null;
    }

    private Rectangle getRotateRightRect() {
        Rectangle rect = this.getRect();
        if (rect != null) {
            int x = rect.x + rect.width - RotateRightImage.getWidth();
            int y = rect.y + rect.height - RotateRightImage.getHeight();
            int w = RotateRightImage.getWidth();
            int h = RotateRightImage.getHeight();
            return new Rectangle(x, y, w, h);
        }
        return null;
    }

    boolean isControllerEvent(MouseEvent event) {
        if (event.getID() == 503) {
            return true;
        }
        if (!this.isEnabled) {
            return false;
        }
        if (event.getID() == 501 || event.getID() == 502 || event.getID() == 500) {
            Point p = event.getPoint();
            Rectangle leftRect = this.getRotateLeftRect();
            if (leftRect != null && leftRect.contains(p)) {
                return true;
            }
            Rectangle rightRect = this.getRotateRightRect();
            if (rightRect != null && rightRect.contains(p)) {
                return true;
            }
        }
        return false;
    }

    void handleEvent(MouseEvent event) {
        Rectangle rightRect;
        Point p;
        if (event.getID() == 503) {
            p = event.getPoint();
            int index = this.browser.getIndex(p);
            this.setIndex(index);
            if (index < 0) {
                return;
            }
        }
        if (!this.isEnabled) {
            return;
        }
        if (event.getID() == 503) {
            boolean changed;
            p = event.getPoint();
            Rectangle leftRect = this.getRotateLeftRect();
            boolean wasHoverLeft = this.hoverLeft;
            boolean bl = this.hoverLeft = leftRect != null && leftRect.contains(p);
            if (this.hoverLeft && !wasHoverLeft || !this.hoverLeft && wasHoverLeft) {
                this.browser.repaint(leftRect);
            }
            rightRect = this.getRotateRightRect();
            boolean wasHoverRight = this.hoverRight;
            boolean bl2 = this.hoverRight = rightRect != null && rightRect.contains(p);
            if (this.hoverRight && !wasHoverRight || !this.hoverRight && wasHoverRight) {
                this.browser.repaint(rightRect);
            }
            if (changed = this.stars.updateHighlighted(p)) {
                Rectangle starsRect = this.stars.getStarsRect();
                this.browser.repaint(starsRect);
            }
        }
        if (event.getID() == 501) {
            ImageDatum datum = this.browser.getImageDatum(this.index);
            Point p2 = event.getPoint();
            Rectangle leftRect = this.getRotateLeftRect();
            if (leftRect != null && leftRect.contains(p2)) {
                RotateActions.rotateLeft(datum, this.browser);
                ArrayList<ImageDatum> datums = this.browser.getSelectedDatums();
                if (datums.contains(datum)) {
                    datums.remove(datum);
                    for (ImageDatum d : datums) {
                        RotateActions.rotateLeft(d, this.browser);
                    }
                }
            }
            if ((rightRect = this.getRotateRightRect()) != null && rightRect.contains(p2)) {
                RotateActions.rotateRight(datum, this.browser);
                ArrayList<ImageDatum> datums = this.browser.getSelectedDatums();
                if (datums.contains(datum)) {
                    datums.remove(datum);
                    for (ImageDatum d : datums) {
                        RotateActions.rotateRight(d, this.browser);
                    }
                }
            }
        }
    }

    void setIndex(int newIndex) {
        int oldIndex = this.index;
        if (newIndex != oldIndex) {
            ImageDatum datum;
            if (oldIndex >= 0) {
                Rectangle oldRect = this.browser.getBounds(oldIndex);
                this.browser.repaint(oldRect);
            }
            if (newIndex >= 0) {
                Rectangle newRect = this.browser.getBounds(newIndex);
                this.browser.repaint(newRect);
            }
            this.index = newIndex;
            this.isEnabled = true;
            if (this.index >= 0 && (datum = this.browser.getImageDatum(this.index)) != null) {
                Rectangle rect = this.getRect();
                this.stars.setup(datum, rect);
                if (datum.getType().hasLznData()) {
                    this.isEnabled = false;
                }
            }
        }
    }

    static {
        try {
            RotateLeftImage = ImageIO.read(ImageDatumControl.class.getResource("resources/rotLeftNormal.png"));
            RotateRightImage = ImageIO.read(ImageDatumControl.class.getResource("resources/rotRightNormal.png"));
            RotateLeftHighlightImage = ImageIO.read(ImageDatumControl.class.getResource("resources/rotLeftHighlight.png"));
            RotateRightHighlightImage = ImageIO.read(ImageDatumControl.class.getResource("resources/rotRightHighlight.png"));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize ImageDatumControl", e);
        }
    }
}

