/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.BrowserScrollPaneUI;
import com.lightcrafts.ui.scroll.CenteringScrollPane;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JViewport;

public class ImageBrowserScrollPane
extends CenteringScrollPane {
    private AbstractImageBrowser browser;

    public ImageBrowserScrollPane() {
        this.setUI(new BrowserScrollPaneUI());
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(31);
        this.setBorder(LightZoneSkin.getPaneBorder());
        this.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (ImageBrowserScrollPane.this.browser != null) {
                    ImageBrowserScrollPane.this.browser.clearSelection();
                }
            }
        });
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ImageBrowserScrollPane.this.browser != null) {
                                ImageBrowserScrollPane.this.browser.repaint();
                            }
                        }
                    });
                }
            }
        });
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
            boolean isSnapping;

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting() && ImageBrowserScrollPane.this.browser != null) {
                    if (!this.isSnapping) {
                        this.isSnapping = true;
                        ImageBrowserScrollPane.this.snapBrowserScroll();
                        this.isSnapping = false;
                    }
                    ImageBrowserScrollPane.this.cancelBrowserTasks();
                }
            }
        });
    }

    public void setBrowser(AbstractImageBrowser browser) {
        this.browser = browser;
        JViewport viewport = this.getViewport();
        viewport.setBackground(AbstractImageBrowser.Background);
        viewport.setView(browser);
        this.validate();
    }

    public AbstractImageBrowser getBrowser() {
        return this.browser;
    }

    private void snapBrowserScroll() {
        int inc = this.browser.getScrollableUnitIncrement(null, 0, 0);
        JViewport viewport = this.getViewport();
        Rectangle viewRect = viewport.getViewRect();
        int upTop = -viewRect.y % inc;
        int downTop = inc + upTop;
        int upBottom = -(viewRect.y + viewRect.height) % inc;
        int downBottom = inc + upBottom;
        int min = Integer.MAX_VALUE;
        int scrollToY = 0;
        if (Math.abs(min) > Math.abs(upTop)) {
            scrollToY = viewRect.y + upTop;
            min = upTop;
        }
        if (Math.abs(min) > Math.abs(downTop)) {
            scrollToY = viewRect.y + viewRect.height + downTop;
            min = downTop;
        }
        if (Math.abs(min) > Math.abs(upBottom)) {
            scrollToY = viewRect.y + upBottom;
            min = upBottom;
        }
        if (Math.abs(min) > Math.abs(downBottom)) {
            scrollToY = viewRect.y + viewRect.height + downBottom;
        }
        Rectangle rect = new Rectangle(0, scrollToY, 0, 0);
        this.browser.scrollRectToVisible(rect);
    }

    private void cancelBrowserTasks() {
        if (this.browser != null) {
            JViewport viewport = this.getViewport();
            Rectangle visible = viewport.getViewRect();
            this.browser.cancelTasks(visible);
        }
    }
}

